#include "LinearBlend.h"
#include "mbed.h"
Serial bob(USBTX,USBRX);

/***********************************************************
Constructor
***********************************************************/
LinearBlend::LinearBlend():start(0)
{
}

/***********************************************************
Initialize Blend Function
***********************************************************/
//Function that sets the blend global variables to ready for blending calculations.
void LinearBlend::init(float end, float s, int t_blend)
{
    slope=(end-s)/t_blend;
    bob.printf("Start: %f, Slope: %f\r\n", start, slope);
    start=s;
}

/***********************************************************
Calculate Blend Function
***********************************************************/
//Function that calculates the blending trajectory, point by point.
  
float* LinearBlend::blend(float ref[])
{
     bob.printf("Start: %f, Slope: %f\r\n", start, slope);   
    //Pointer to the variable to store the trajectory point for the left side
    for(int i=0; i<=t_blend; i++) {
        ref[i]=slope*i+start;
        
    }

    return ref;
}
