#include "mbed.h"
#include "cmsis_os.h"
#include "AHRS.h"
#include "Parameter.h"
//#include "MARGfilter.h"
//#include "IMUfilter.h"
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Serial pc(USBTX, USBRX);

I2C I2CBus(p28, p27);
Timer GlobalTime;

AHRS Ahrs(I2CBus,GlobalTime);
Parameter Parm(GlobalTime);
//MARGfilter MargFilter (GlobalTime);
//IMUfilter IMUfilter(GlobalTime);
#define PI 3.1415926536
#define toDegrees(x) (x * 57.2957795)//Multiply radians to get degrees.
#define toRadians(x) (x * 0.01745329252)//Multiply degrees to get radians.
//#define toAcceleration(x) (x * (3 * g0 * 0.001)) //Full scale resolution on the ADXL345 is 3mg/LSB.


// Sensor task..og sensor opdatering **********************
void Sensor_thread(void const *argument)
{
  //  Ahrs.Mag.AutoCalibration= 1;      // In Echtzeit kalibrieren 
    Ahrs.Init();
    Ahrs.Gyro.Calibrate(500);         // 0.5 sec Calibrer gyro
    short Raw1g[3]= {0, 0, -2870}; // -2870 //1 g sind ca -2870 auf der 3. Achse
    Ahrs.Acc.Calibrate(500, Raw1g);   // 0.5 Sekunden kalibrieren
    Ahrs.Mag.AutoCalibration= 1;      // In Echtzeit kalibrieren
  //  Ahrs.Mag.Update(10,10);
  
    while(1)  //Sensoren updaten loop
    {
     Ahrs.Acc.Update(8,2);
     led1 = !led1;
     Ahrs.Mag.Update(4,2);
     led1 = !led1;
     Ahrs.Gyro.Update(4,2);
     led1 = !led1;
   }
}


// IMU task  *****************************
void IMU_thread(void const *argument) {
osDelay(5000);
//MargFilter.reset(Parm.GYRO_MEAS_ERROR,Parm.GYRO_MEAS_DRIFT);
//IMUfilter.setGyroError(Parm.GYRO_MEAS_ERROR);
 while(1) // MargFilter loop
   {
   // MargFilter.updateFilter (-Ahrs.Gyro.Rate[0],Ahrs.Gyro.Rate[1],Ahrs.Gyro.Rate[2],
                           //  Ahrs.Acc.Acc[0]  ,Ahrs.Acc.Acc[1]  ,Ahrs.Acc.Acc[2],
                          //   Ahrs.Mag.Mag[0]  ,Ahrs.Mag.Mag[1]  ,Ahrs.Mag.Mag[2]);
      
   // IMUfilter.updateFilter (Ahrs.Gyro.Rate[1],Ahrs.Gyro.Rate[0],Ahrs.Gyro.Rate[2],
    //                        Ahrs.Acc.Acc[0]  ,Ahrs.Acc.Acc[1]  ,Ahrs.Acc.Acc[2]);
                                                   
  // MargFilter.computeEuler ();
  //  IMUfilter.computeEuler();
   Ahrs.Update();
    led2 = !led2;
    osDelay(Parm.IMU_RATE);
   }
}


// Parameter task  *****************************
void Parmeter_thread(void const *argument) {

 while(1)
   {
   Ahrs.Beta = sqrt(3.0 / 4.0) * (PI * (Parm.GYRO_MEAS_ERROR / 180.0));// gyroscope measurement error in rad/s (shown as 5 deg/s)
  // Ahrs.zeta = sqrt(3.0 / 4.0) * (PI * (Parm.GYRO_MEAS_DRIFT / 180.0)); // gyroscope measurement error in rad/s/s (shown as 0.2f deg/s/s)
//  IMUfilter.setGyroError(Parm.GYRO_MEAS_ERROR);
    led3 = !led3;
    osDelay(10000); // load parm pr 10 sec
    Parm.Loadparm();
   }
 
}

    
 

osThreadDef(Sensor_thread, osPriorityHigh,  1, DEFAULT_STACK_SIZE);
osThreadDef(IMU_thread,   osPriorityNormal, 1, DEFAULT_STACK_SIZE);
osThreadDef(Parmeter_thread, osPriorityLow, 1, DEFAULT_STACK_SIZE* 2.25);

// MAIN ********************************

int main() {
   I2CBus.frequency(400000);
   GlobalTime.start();
   Parm.Loadparm();
   pc.baud(9600);
   osThreadCreate(osThread(Sensor_thread), NULL);
   osThreadCreate(osThread(IMU_thread), NULL);
   osThreadCreate(osThread(Parmeter_thread), NULL); 
   osDelay(2000);
   
    while(1)
    {
  
 
      //  pc.printf("%f,%f,%f\r\n",toDegrees(Ahrs.Roll),toDegrees(Ahrs.Nick),toDegrees(Ahrs.Yaw));
       //     pc.printf("%f,%f,%f\n",toDegrees(IMUfilter.getRoll()),toDegrees(IMUfilter.getPitch()),toDegrees(IMUfilter.getYaw()));
    //     pc.printf("%f,%f,%f\n",Ahrs.Mag.Mag[0],Ahrs.Mag.Mag[1],Ahrs.Mag.Mag[2]);
     //     pc.printf("%f,%f,%f\n",Ahrs.Acc.Acc[0],Ahrs.Acc.Acc[1],Ahrs.Acc.Acc[2]);
        //  pc.printf("%f,%f,%f\n",Ahrs.Gyro.Rate[0],Ahrs.Gyro.Rate[1],Ahrs.Gyro.Rate[2]);
        
       pc.printf("%f,%f,%f\n",(toDegrees(Ahrs.Roll)),toDegrees((Ahrs.Nick)),toDegrees((Ahrs.Yaw)));
            
      osDelay(100);    
    }
 
}
