#ifndef MBED_PARAMETER_H
#define MBED_PARAMETER_H
#include "mbed.h"


class Parameter {
public:
Parameter( Timer & GlobalTime_); 

    void flash(int n);
 
      float RATE;  //PID loop timing

//PID tuning constants.
      float L_KC;//Forward left motor Kc
      float L_TI;    //Forward left motor Ti
      float L_TD;    //Forward left motor Td
      float R_KC; //Forward right motor Kc
      float R_TI;    //Forward right motor Ti
      float R_TD;    //Forward right motor Td
 
//PID input/output limits.
      int L_INPUT_MIN;     //Forward left motor minimum input
      int L_INPUT_MAX;  //Forward left motor maximum input
      float L_OUTPUT_MIN;  //Forward left motor minimum output
      float L_OUTPUT_MAX;  //Forward left motor maximum output

      int R_INPUT_MIN;     //Forward right motor input minimum
      int R_INPUT_MAX;  //Forward right motor input maximum
      float R_OUTPUT_MIN;  //Forward right motor output minimum
      float R_OUTPUT_MAX;  //Forward right motor output maximum

//Physical dimensions.
      float PULSES_PER_REV;   //(59 pulses pr motor omgang gear 50:1)
      float WHEEL_DIAMETER; //mm
      float ROTATION_DISTANCE;  //mm
      float REVS_PER_ROTATION; //     (ROTATION_DISTANCE / WHEEL_DIAMETER);
      float PULSES_PER_ROTATION;//   (REVS_PER_ROTATION * PULSES_PER_REV);
      float PULSES_PER_MM;//        (PULSES_PER_REV / WHEEL_DIAMETER);
      float DISTANCE_PER_PULSE;//   (WHEEL_DIAMETER / PULSES_PER_REV);
      float _WHEEL_DISTANCE; //        (ROTATION_DISTANCE / DISTANCE_PER_PULSE);
      float GYRO_MEAS_ERROR;
      float GYRO_MEAS_DRIFT;
      int   CALIBRATION_SAMPLES;
      int   SAMPLES;
      float IMU_RATE;     //      0.025
      float COMMAND_RATE; //0.005
      float PID_RATE;//     0.005
      float SENSOR_RATE;//       0.005
      float GYROSCOPE_GAIN; // (1 / 14.375)
      float ACCELEROMETER_GAIN;// 3.4346447e-3;      //(0.0034346447 * g0)  //0.0034346447; //Beschleunigung in Meter pro Quadratsekunde umrechnen
      float COMPASS_GAIN; 
 
  void Loadparm();

  
private:  
  //  DigitalOut _pin;
     Timer & GlobalTime;
  
   
   
};
#endif
