#include "mbed.h"
#include "cmsis_os.h"
#include "ConfigFile.h"
#include "Parameter.h"

//Filesystem.
 LocalFileSystem local("local");


 ConfigFile cfg; // configfile lib   
// Loader alle paramert from local/input.cfg

 Parameter::Parameter(Timer & GlobalTime_) :  GlobalTime(GlobalTime_) {

 }
 

   float RATE;  //PID loop timing

//PID tuning constants.
      float L_KC;//Forward left motor Kc
      float L_TI;    //Forward left motor Ti
      float L_TD;    //Forward left motor Td
      float R_KC; //Forward right motor Kc
      float R_TI;    //Forward right motor Ti
      float R_TD;    //Forward right motor Td
 
//PID input/output limits.
      int L_INPUT_MIN;     //Forward left motor minimum input
      int L_INPUT_MAX;  //Forward left motor maximum input
      float L_OUTPUT_MIN;  //Forward left motor minimum output
      float L_OUTPUT_MAX;  //Forward left motor maximum output

      int R_INPUT_MIN;     //Forward right motor input minimum
      int R_INPUT_MAX;  //Forward right motor input maximum
      float R_OUTPUT_MIN;  //Forward right motor output minimum
      float R_OUTPUT_MAX;  //Forward right motor output maximum

//Physical dimensions.
      float PULSES_PER_REV;   //(59 pulses pr motor omgang gear 50:1)
      float WHEEL_DIAMETER; //mm
      float ROTATION_DISTANCE;  //mm
      float REVS_PER_ROTATION; //     (ROTATION_DISTANCE / WHEEL_DIAMETER);
      float PULSES_PER_ROTATION;//   (REVS_PER_ROTATION * PULSES_PER_REV);
      float PULSES_PER_MM;//        (PULSES_PER_REV / WHEEL_DIAMETER);
      float DISTANCE_PER_PULSE;//   (WHEEL_DIAMETER / PULSES_PER_REV);
      float _WHEEL_DISTANCE; //        (ROTATION_DISTANCE / DISTANCE_PER_PULSE);
      float GYRO_MEAS_ERROR;
      float GYRO_MEAS_DRIFT;
      int   CALIBRATION_SAMPLES;
      int   SAMPLES;
      float IMU_RATE;     //      0.025
      float COMMAND_RATE; //0.005
      float PID_RATE;//     0.005
      float SENSOR_RATE;//       0.005
      float GYROSCOPE_GAIN; // (1 / 14.375)
      float ACCELEROMETER_GAIN;// 3.4346447e-3;      //(0.0034346447 * g0)  //0.0034346447; //Beschleunigung in Meter pro Quadratsekunde umrechnen
      float COMPASS_GAIN; 

void Parameter::Loadparm(void) {

    char *key1 ="RATE"; //ATE 0.01        //PID loop timing
    char *key2 ="L_KC"; // 0.4312 //Forward left motor Kc
    char *key3 ="L_TI"; // 0.1    //Forward left motor Ti
    char *key4 ="L_TD"; // 0.0    //Forward left motor Td
    char *key5 ="R_KC"; // 0.4620 //Forward right motor Kc
    char *key6 ="R_TI"; // 0.1    //Forward right motor Ti
    char *key7 ="R_TD"; // 0.0    //Forward right motor Td

    char *key8 ="L_INPUT_MIN"; // 0     //Forward left motor minimum input
    char *key9 ="L_INPUT_MAX"; // 3000  //Forward left motor maximum input
    char *key10="L_OUTPUT_MIN";// 0.0  //Forward left motor minimum output
    char *key11="L_OUTPUT_MAX"; // 0.9  //Forward left motor maximum output

    char *key12="R_INPUT_MIN"; // 0     //Forward right motor input minimum
    char *key13="R_INPUT_MAX"; // 3200  //Forward right motor input maximum
    char *key14="R_OUTPUT_MIN"; // 0.0  //Forward right motor output minimum
    char *key15="R_OUTPUT_MAX"; // 0.9  //Forward right motor output maximum
    char *key16="PULSES_PER_REV"; //        120*50   //(59 pulses pr motor omgang gear 50:1)
    char *key17="WHEEL_DIAMETER"; //        127.32 //mm
    char *key18="ROTATION_DISTANCE"; //     400.0  //mm
    char *key19="_WHEEL_DISTANCE"; //        (ROTATION_DISTANCE / DISTANCE_PER_PULSE);
    char *key20="GYRO_MEAS_ERROR";
    char *key21="GYRO_MEAS_DRIFT";
    char *key22="CALIBRATION_SAMPLES";
    char *key23="SAMPLES";
    char *key24="IMU_RATE";     //      0.025
    char *key25="COMMAND_RATE"; //0.005
    char *key26="PID_RATE"; //   0.005
    char *key27="SENSOR_RATE";//       0.005
    char *key28="GYROSCOPE_GAIN";// (1 / 14.375)
    char *key29="ACCELEROMETER_GAIN";// 3.4346447e-3;      //(0.0034346447 * g0)  //0.0034346447; //Beschleunigung in Meter pro Quadratsekunde umrechnen
    char *key30="COMPASS_GAIN"; 
                char value[BUFSIZ];
                /*
                * Read a configuration file from a mbed.
                */
             //   printf("indlaeser parameter liste\n");

                if (!cfg.read("/local/input.cfg")) {
                printf("Failure to read /local/input.cfg configuration file.system stoppet!!! \n");
                exit(EXIT_FAILURE);
                           }

       
        // Get a configuration value.
         
                if (cfg.getValue(key1 , &value[0], sizeof(value))) RATE=atof(value);
                if (cfg.getValue(key2 , &value[0], sizeof(value))) L_KC=atof(value);
                if (cfg.getValue(key3 , &value[0], sizeof(value))) L_TI=atof(value);
                if (cfg.getValue(key4 , &value[0], sizeof(value))) L_TD=atof(value);
                if (cfg.getValue(key5 , &value[0], sizeof(value))) R_KC=atof(value);
                if (cfg.getValue(key6 , &value[0], sizeof(value))) R_TI=atof(value);
                if (cfg.getValue(key7 , &value[0], sizeof(value))) R_TD=atof(value);
                if (cfg.getValue(key8 , &value[0], sizeof(value))) L_INPUT_MIN=atoi(value);
                if (cfg.getValue(key9 , &value[0], sizeof(value))) L_INPUT_MIN=atoi(value);
                if (cfg.getValue(key10, &value[0], sizeof(value))) L_OUTPUT_MIN=atof(value);
                if (cfg.getValue(key11, &value[0], sizeof(value))) L_OUTPUT_MAX=atof(value);
                if (cfg.getValue(key12, &value[0], sizeof(value))) R_INPUT_MIN=atoi(value);
                if (cfg.getValue(key13, &value[0], sizeof(value))) R_INPUT_MAX=atoi(value);
                if (cfg.getValue(key14, &value[0], sizeof(value))) R_OUTPUT_MIN=atof(value);
                if (cfg.getValue(key15, &value[0], sizeof(value))) R_OUTPUT_MAX=atof(value);
                if (cfg.getValue(key16, &value[0], sizeof(value))) PULSES_PER_REV=atof(value);
                if (cfg.getValue(key17, &value[0], sizeof(value))) WHEEL_DIAMETER=atof(value);
                if (cfg.getValue(key18, &value[0], sizeof(value))) ROTATION_DISTANCE=atof(value);
                if (cfg.getValue(key19, &value[0], sizeof(value))) _WHEEL_DISTANCE=atof(value); //        (ROTATION_DISTANCE / DISTANCE_PER_PULSE);
                if (cfg.getValue(key20, &value[0], sizeof(value))) GYRO_MEAS_ERROR=atof(value);
                if (cfg.getValue(key21, &value[0], sizeof(value))) GYRO_MEAS_DRIFT=atof(value);
                if (cfg.getValue(key22, &value[0], sizeof(value))) CALIBRATION_SAMPLES=atof(value);
                if (cfg.getValue(key23, &value[0], sizeof(value))) SAMPLES=atof(value);
                if (cfg.getValue(key24, &value[0], sizeof(value))) IMU_RATE=atof(value);     //      0.025
                if (cfg.getValue(key25, &value[0], sizeof(value))) COMMAND_RATE=atof(value); //0.005
                if (cfg.getValue(key26, &value[0], sizeof(value))) PID_RATE=atof(value); //     0.005
                if (cfg.getValue(key27, &value[0], sizeof(value))) SENSOR_RATE=atof(value); //       0.005
                if (cfg.getValue(key28, &value[0], sizeof(value))) GYROSCOPE_GAIN=atof(value); // (1 / 14.375)
                if (cfg.getValue(key29, &value[0], sizeof(value))) ACCELEROMETER_GAIN=atof(value);// 3.4346447e-3;      //(0.0034346447 * g0)  //0.0034346447; //Beschleunigung in Meter pro Quadratsekunde umrechnen
                if (cfg.getValue(key30, &value[0], sizeof(value))) COMPASS_GAIN=atof(value); 
        
        
             //  printf("Parameter indlaesning udfort. \n");
              
 }
///////////////////////////////////////////////////
/*  input.cfg
RATE=5
L_KC=0.4312
L_TI=0.1 
L_TD=0.0  
R_KC=0.4620
R_TI=0.1 
R_TD=0.0 
L_INPUT_MIN=0 
L_INPUT_MAX=3000
L_OUTPUT_MIN=0.0
L_OUTPUT_MAX=0.9 
R_INPUT_MIN=0    
R_INPUT_MAX=3200 
R_OUTPUT_MIN=0.0 
R_OUTPUT_MAX=0.9 
PULSES_PER_REV=6000
WHEEL_DIAMETER=127.32
ROTATION_DISTANCE=400.0
_WHEEL_DISTANCE=0
GYRO_MEAS_ERROR=-0.0002
CALIBRATION_SAMPLES=250
SAMPLES=4
IMU_RATE=10
ACCELEROMETER_RATE=5
ACCELEROMETER_GAIN=3.4346447e-3
COMPASS_GAIN=1

COMMAND_RATE=1000
SENSOR_RATE=10
PID_RATE=500
*/







