#pragma once

//I2C Adresse, entweder 0x40 oder 0x41, abhaengig von Pin VDDIO
#define BMA180_ADRESS 0x41

//Beschleunigung in Meter pro Quadratsekunde umrechnen
const float fConvMPSS= 3.4346447e-3;

class BMA180
{
private:
    I2C & I2CBus;
    Timer & GlobalTime;
    
    //Offset
    float Offset[3];
    
public:
    //Beschleunigung auf allen drei Achsen
    short RawAcc[3];        //Rohdaten
    float Acc[3];           //kalibrierte Rohdaten in m/s^2
    
    
    //Initialisieren
    BMA180(I2C & I2CBus_, Timer & GlobalTime_);
    void Init();

private:    
    //Rohdaten lesen
    void ReadRawData();
    
public:
    //Update-Methode
    //- Holt aktuelle Daten vom Sensor ab
    //- Rechnet das Offset hinzu
    //- Rechnet in andere Einheiten um
    void Update(int antal_samples,int samples_delay);
    
    //Kalibrieren aktivieren
    //- pRaw1g: Array short[3] ideale Rohdaten f&#65533;r 1g = ca. {0, 0, -2870}
    void Calibrate(int ms, short * pRaw1g);
};
