#include "mbed.h"
#include "BMA180.h"
#include "cmsis_os.h"
#define I2CADR_W(ADR)           (ADR<<1&0xFE)
#define I2CADR_R(ADR)           (ADR<<1|0x01)

//Initialisieren
BMA180::BMA180(I2C & I2CBus_, Timer & GlobalTime_)
    : I2CBus(I2CBus_),
      GlobalTime(GlobalTime_)
{}

void BMA180::Init()
{
    //Nullsetzen
    for(int i= 0; i < 3; i++)
    {
        Offset[i]= 0.0;
        RawAcc[i]= 0;
        Acc[i]= 0;
    }
    
       
    //BMA180 initialisieren
    char tx[2];
    char rx[1];
    
    //Schreiben aktivieren
    tx[0]= 0x0D;
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 1);
    I2CBus.read (I2CADR_R(BMA180_ADRESS), rx, 1);
    tx[1]= rx[0] & 0xEF | (0x01<<4);
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 2);
    
    //Mode: Low-Noise
    tx[0]= 0x30;
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 1);
    I2CBus.read (I2CADR_R(BMA180_ADRESS), rx, 1);
    tx[1]= rx[0] & 0xFC | (0x00<<0);
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 2);
    
    //Range: +-3g
    tx[0]= 0x35;
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 1);
    I2CBus.read (I2CADR_R(BMA180_ADRESS), rx, 1);
    tx[1]= rx[0] & 0xF1 | (0x03<<1);
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 2);
    
    //Bandbreitenfilter: 10Hz    
    tx[0]= 0x20;
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 1);
    I2CBus.read (I2CADR_R(BMA180_ADRESS), rx, 1);
    tx[1]= rx[0] & 0x0F | (0x00<<4);
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 2);
      
    Update(3,10);
}


//Rohdaten lesen
void BMA180::ReadRawData()
{
    //Beschleunigung f�r alle 3 Achsen auslesen
    char tx[1];
    char rx[6];
    
    tx[0]= 0x02;
    I2CBus.write(I2CADR_W(BMA180_ADRESS), tx, 1);
    I2CBus.read (I2CADR_R(BMA180_ADRESS), rx, 6); 
    
    //Aus den einzelnen Bytes den 16-Bit-Wert zusammenbauen
    //Die 2 Statusbits muessen "abgeschnitten" werden  
    RawAcc[0]= (rx[1]<<8|rx[0]) & 0xFFFC; // x
    RawAcc[1]= (rx[3]<<8|rx[2]) & 0xFFFC; // y
    RawAcc[2]= (rx[5]<<8|rx[4]) & 0xFFFC; // z
    RawAcc[0]/= 4;
    RawAcc[1]/= 4;
    RawAcc[2]/= 4;
}
   
//Update-Methode
void BMA180::Update(int antal_samples,int samples_delay)
{
     float AvgSampelAcc[3]= {0.0, 0.0, 0.0};    
     int AvgSampel= 0;
    
    
    while(AvgSampel <antal_samples) // Antal Samples
    {    
        //Rohdaten lesen
        ReadRawData();
        
        //Durchschnitt bilden
        AvgSampelAcc[0]+= (float)RawAcc[0];
        AvgSampelAcc[1]+= (float)RawAcc[1];
        AvgSampelAcc[2]+= (float)RawAcc[2];
        AvgSampel+= 1.0;
        
        osDelay(samples_delay);
    } 
    
   
    //Beschleunigung f�r alle 3 Achsen auslesen
       
    //Umrechnungen
    Acc[0]= fConvMPSS * ((float)(AvgSampelAcc[0] / AvgSampel) + Offset[0]);
    Acc[1]= fConvMPSS * ((float)(AvgSampelAcc[1] / AvgSampel) + Offset[1]);
    Acc[2]= fConvMPSS * ((float)(AvgSampelAcc[2] / AvgSampel) + Offset[2]);
    
    
    
}

//Kalibrieren
void BMA180::Calibrate(int ms, short * pRaw1g)
{
    float AvgCalibAcc[3]= {0.0, 0.0, 0.0};    
    float AvgCalibSampels= 0.0;
    
    //Ende der Kalibrierung in ms Millisekunden berechnen
    int CalibEnd= GlobalTime.read_ms() + ms;
    
    while(GlobalTime.read_ms() < CalibEnd)
    {    
        //Rohdaten lesen
        ReadRawData();
        
        //Durchschnitt bilden
        AvgCalibAcc[0]+= (float)RawAcc[0];
        AvgCalibAcc[1]+= (float)RawAcc[1];
        AvgCalibAcc[2]+= (float)RawAcc[2];
        AvgCalibSampels+= 1.0;
        
        osDelay(10);
    }
    
    //Genug Daten gesammelt, jetzt den Durchschnitt bilden
    Offset[0]= -((float)(pRaw1g[0]) + AvgCalibAcc[0] / AvgCalibSampels);
    Offset[1]= -((float)(pRaw1g[1]) + AvgCalibAcc[1] / AvgCalibSampels);
    Offset[2]= -((float)(pRaw1g[2]) + AvgCalibAcc[2] / AvgCalibSampels);
}
