#pragma once

#include "BMA180.h"
#include "HMC5883.h"
#include "ITG3200.h"
#include "GTMath.h"

////////////////////////////////////////////////////////////////
//Attitude Heading Reference System
class AHRS
{
public:
    ////////////////////////////////////////////////////////////////
    //Interfaces: Selbst kalibrieren!
    Timer & GlobalTime;
    BMA180 Acc;
    HMC5883 Mag;
    ITG3200 Gyro;
    
    ////////////////////////////////////////////////////////////////
    //AHRS Outputs
    float dT;                   //Time Step
    Quaternion qWorld;          //absolute Orientierung der Sensoren
    Quaternion qSensor;         //relative Orientierung des Raums
    Vector3 vEulerAngles;       //absolute Eulerwinkel
    float Roll, Nick, Yaw;      //Eulerwinkel
    
    ////////////////////////////////////////////////////////////////
    //Init
    AHRS(I2C & I2CBus_, Timer & GlobalTime_);
    void Init();
    
    ////////////////////////////////////////////////////////////////
    //Update
    void Update();
    
    //Madgwick AHRS/IMU Code (see http://www.x-io.co.uk/node/8#open_source_imu_and_ahrs_algorithms)
    float Beta;             //Algorithm Gain
    float q0, q1, q2, q3;   //qWorld in Madgwicks Koordinatensystem (wird in Update angepasst)

     void MadgwickAHRSupdate(float gx, float gy, float gz, float ax, float ay, float az, float mx, float my, float mz);
    void MadgwickAHRSupdateIMU(float gx, float gy, float gz, float ax, float ay, float az);
};
