#pragma once

//I2C Adresse, entweder 0x68 oder 0x69, abhaengig von Pin AD0
#define ITG3200_ADRESS 0x68

//Gyro-Rohdaten in Radiant pro Sekunde umrechnen
const float fConvRPS= 1.2141420883e-3;

class ITG3200 {
protected:
    I2C & I2CBus;
    Timer & GlobalTime;

public:
    //Offset
    float Offset[3];

    //Drehgeschwindigkeit um alle drei Achsen
    short RawRate[3];       //Rohdaten
    float Rate[3];          //kalibrierte Drehraten in Radiant pro Sekunde


    //Initialisieren
    ITG3200(I2C & I2CBus_, Timer & GlobalTime_);
    void Init();


private:
    //Rohdaten lesen
    void ReadRawData();

public:
    //Update-Methode
    void Update();

    //Kalibrieren
    void Calibrate(int ms);
};
