/* mbed Example Program
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"

long dataUnix = 0;
int settore = 0;
int ore = 0;
int minuti = 0;

        char mon[30]="Mon";
        char tue[30]="Tue";
        char wed[30]="Wed";
        char thu[30]="Thu";
        char fri[30]="Fri";
        char sat[30]="Sat";
        char sun[30]="Sun"; 
/*
Il Software a seconda se è Lunedì, Martedì ecc leggerà
dalla schedina microSD il file relativo

File EventiRilascioLu.txt
I campi separati da virgola sono :
Ora     :
Settore _n  :
Settore _n  :
Settore _n  :
Settore _n  :
Esempio righe file :
0815,S04,S05 ( vuol dire che alle 8,15 dovrà cadere nell’imbuto il Cortisone e il Cardura )
1200,S06,S09,S12
1800,S03,S05,S10
2000,S01,S04

File EventiRilascioMa.txt
I campi separati da virgola sono :
Ora     :
Settore _n  :
Settore _n  :
Settore _n  :
Settore _n  :
Esempio righe file :
0815,S01,S05
1200,S06,S09,S12
1800,S03,S05,S10

*/


// questi dati li caricherò leggendoli dalla scheda microSD
// all'inizio del programma



char giorno1[4]="Sun"; 
char ora1[3]="04";
char min1[3]="31";
char am1[3]="AM";
char S1[2]="5";
char giorno2[4]="Sun"; 
char ora2[3]="08";
char min2[3]="20";
char am2[3]="PM";
char S2[2]="3";
char giorno3[4]="Mon"; 
char ora3[3]="04";
char min3[3]="33";
char am3[3]="AM";
char S3[2]="5";
char giorno4[4]="Tue"; 
char ora4[3]="04";
char min4[3]="36";
char am4[3]="AM";
char S4[2]="3";
char giorno5[4]="Tue"; 
char ora5[3]="05";
char min5[3]="20";
char am5[3]="PM";
char S5[2]="5";
char giorno6[4]="Fri"; 
char ora6[3]="05";
char min6[3]="10";
char am6[3]="AM";
char S6[2]="2";
char giorno7[4]="Fri"; 
char ora7[3]="06";
char min7[3]="31";
char am7[3]="PM";
char S7[2]="5";

char am[3]="AM";
char pm[3]="PM";
char ampm[3];
char ora[3];
char minu[3];       


// valori del giorno corrente
int ora_d=0;
int min_d=0;
int sett_d1=0;
int sett_d2=0;
int sett_d3=0;
int sett_d4=0;
int sett_d5=0;
int sett_d6=0;
int sett_d7=0;


// pin a cui è collegato il sensore di vibrazione
// che segnala la caduta della pillola nell'imbuto
DigitalIn vibra(D7);
int present_condition = 0;
int previous_condition = 0;

int step_speed = 1200 ; // set default motor speed
int numstep = 514 ; // defines full turn of 360 degree
//you might want to calibrate this value according to your motor
int statomax =7;
int kmax = 8;
int stato;


// pin a cui è collegato il motore passo-passo
DigitalOut IN1(D8);
DigitalOut IN2(D9);
DigitalOut IN3(D10);
DigitalOut IN4(D11);

const int MotoreOFF = 99; // motore spento


void leggomicroSD()
{
    
}
void leggoSD(int gg)
{
// leggo da microSD il file EventiRilascioLu.txt
// in ragione del parametro del giorno della settimana
// passato come parametro
    if (gg==1)
    {
   //    leggo da SD EventiRilascioLu.txt
   // 0815,S04,S05
   // 1200,S06,S09,S12
   // 1800,S03,S05,S10 
   
   ora_d=8;
   min_d=15;
   sett_d1=4;
   sett_d2=5;

   
    }

    if (gg==2)
    {
   //    leggo da SD EventiRilascioLu.txt
  //  0815,S01,S05
  //  1200,S06,S09,S12
  //  1800,S03,S05,S10
   
   ora_d=8;
   min_d=15;
   sett_d1=1;
   sett_d2=5;
   
    }
    
       if (gg==3)
    {
   //    leggo da SD EventiRilascioLu.txt
  //  0815,S01,S05
  //  1200,S06,S09,S12
  //  1800,S03,S05,S10
   
   ora_d=9;
   min_d=20;
   sett_d1=3;
   sett_d2=6;
   
    }

     printf(" ora: %d\r\n", ora_d);
    printf(" minuto settore: %d\r\n", min_d);       
     printf(" Settore1 : %d\r\n", sett_d1);
    printf(" Settore2 : %d\r\n", sett_d2);
}

void Uscita( int i4,int i3,int i2,int i1)
{
    if (i1==1) IN1=1; else IN1=0;
    if (i2==1) IN2=1; else IN2=0;
    if (i3==1) IN3=1; else IN3=0;
    if (i4==1) IN4=1; else IN4=0;

}



void EseguiPasso(int stato)
{
int i1,i2,i3,i4;

  switch ( stato )
    {// vedi tabella nel pdf del motore passo passo
       case 0: Uscita(0,0,0,1); break;
       case 1: Uscita(0,0,1,1); break;
       case 2: Uscita(0,0,1,0); break; 
       case 3: Uscita(0,1,1,0); break;
       case 4: Uscita(0,1,0,0); break;
       case 5: Uscita(1,1,0,0); break;
       case 6: Uscita(1,0,0,0); break;
       case 7: Uscita(1,0,0,1); break;
       case 8: Uscita(0,0,0,1); break;
       case 9: Uscita(0,0,1,1); break;
       case 10: Uscita(0,0,1,0); break; 
       case 11: Uscita(0,1,1,0); break;
       case 12: Uscita(0,1,0,0); break;
       case 13: Uscita(1,1,0,0); break;
       case 14: Uscita(1,0,0,0); break;

       case MotoreOFF: //OFF
          Uscita(0,0,0,0); break;
    } 
            wait_ms(1);
 //  delay(1); //ritardo almeno 1 mS
}  

void RitardoAccensione()
{ //attesa prima di attivare il motore
  EseguiPasso(MotoreOFF); 
  for(int i=0; i<10; i++)
   {

   } 
}  


void posizSettore()
{ //attesa prima di attivare il motore
        stato=0; //inizio da uno stato arbitrario


if (kmax>0)
{
  stato=0; //inizio da uno stato arbitrario

  for(int k=0; k<kmax; k++) //Rotazione Oraria
 // for(int k=0; k<4; k++) //Rotazione Oraria
    {
        for (int i=0; i<numstep; i++)  //45 gradi a ciclo
 //       for (int i=0; i<514; i++)  //45 gradi a ciclo
//    for (int i=0; i<1024; i++)  //90 gradi a ciclo
            { 
                EseguiPasso(stato);
                stato=stato+1; // avanza nella tabella
/*        printf("Stato : \r\n");
        printf("%d\r\n",stato);
        printf("k  : \r\n");
        printf("%d\r\n",k);
        */
                if ((stato)>statomax)
                    {
                        stato=0; 
 //       if ((stato)>7) stato=0; 
                    } 
                EseguiPasso(MotoreOFF);  
    //            wait_ms(500);  // pausa di mezzo secondo
            }  
        wait_ms(1000);  // pausa di 1 secondo
    }
  for(int k=0; k<kmax; k++) //Rotazione AntiOraria
//  for(int k=0; k<4; k++) //Rotazione AntiOraria
    {
        for (int i=0; i<numstep; i++)  //45 gradi a ciclo
//        for (int i=0; i<514; i++)  //45 gradi a ciclo
//    for (int i=0; i<1024; i++)  //90 gradi a ciclo
            { 
                EseguiPasso(stato);
                stato=stato-1; //torna indietro nella tabella
 /*       printf("Stato : \r\n");
        printf("%d\r\n",stato);
        printf("k  : \r\n");
        printf("%d\r\n",k);                
        */        
                if ((stato)<0)
                    {
                         stato=statomax; 
 //       if ((stato)<0) stato=7; 
                    } 
                EseguiPasso(MotoreOFF);  
       //         wait_ms(500); 
            }
    wait_ms(1000); 
    }
            }
 
}

int main() {


        printf("Inserisci numero della data UNIX \r\n");
        scanf("%li", &dataUnix);
        printf("%li\n",dataUnix);

//    set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37

    set_time(dataUnix);  // Set RTC time to Data KB

// leggo dalla scheda microD le scadenze Medicine e le metto in apposite variabili

    //    leggomicroSD();
          
    while (true) {
        previous_condition = present_condition;
        present_condition = vibra.read();    
        printf(" VALORE : %d\r\n", present_condition);   
        if (previous_condition != present_condition) {
            printf(" Pillola caduta : %d\r\n", present_condition);
 // attesa per verificare a video il messaggio di pillola caduta           
                wait_ms(1000);   
                    }
 
 
        time_t seconds = time(NULL);
        
 //       printf("Time as seconds since January 1, 1970 = %u\n", (unsigned int)seconds);
 //       
        printf("Time as a basic string = %s", ctime(&seconds));

        char bufH[15];
        char buf[3];
        
        strftime(buf,3, "%a,%d %m %Y.%H:%M:%S\r", localtime(&seconds));   
 


   if(strncmp(buf, mon, 3)==0)
    {
        printf("Ho letto LUNEDI  \r\n");
        // se non la ho già letta leggo il file   EventiRilascioLu.txt
                   leggoSD(1);        

 
    }
   if(strncmp(buf, tue, 3)==0)
    {
        printf("Ho letto MARTEDI  \r\n"); 
                    leggoSD(2);      
    }

   if(strncmp(buf, wed, 3)==0)
    {
        printf("Ho letto MERCOLEDI  \r\n"); 
                           leggoSD(3);        
    }  
   if(strncmp(buf, thu, 3)==0)
    {
        printf("Ho letto GIOVEDI  \r\n");    
    }
   if(strncmp(buf, fri, 3)==0)
    {
        printf("Ho letto VENERDI  \r\n");    
    }

   if(strncmp(buf, sat, 3)==0)
    {
        printf("Ho letto SABATO  \r\n");    
    }  
   if(strncmp(buf, sun, 3)==0)
    {
        printf("Ho letto DOMENICA  \r\n");    
    }  
 
 
 
    
// metto l'0ra di sistema in buffer per poi estrarre l'ora , i minuti , e ampm
// che in seguito confronterò con quelli memorizzati sulla scheda microSD
// caricati dal medico via WiFi
        char buffer[32];
        strftime(buffer, 8, "%I:%M %p\n", localtime(&seconds));
  //      printf("Time as a custom formatted string = %s\r\n", buffer);
  
  // estraggo ora dal buffer
        ora[0] = buffer[0];
        ora[1] = buffer[1];
  // estraggo i minuti dal buffer
        minu[0] = buffer[3];
        minu[1] = buffer[4];
                        
        printf("ora = %s\r\n", ora);
        printf("minuti = %s\r\n", minu);
  // estraggo ampm (mattina-pomeriggio) dal buffer 
        ampm[0] = buffer[6];
        ampm[1] = buffer[7];        


        printf("Mattina/Pomeriggio= %s\r\n", ampm);

                wait_ms(1000);


    if(strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0)
    {
        printf("è ora medicina e minuto prima MEDICINA  \r\n");    
    } 

// verifico
    if(strncmp(buf, giorno1, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S1  \r\n");    
    } 
    if(strncmp(buf, giorno2, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S2  \r\n");    
    } 
    if(strncmp(buf, giorno3, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S3 \r\n");    
    } 
    if(strncmp(buf, giorno4, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S4 \r\n");    
    } 
    if(strncmp(buf, giorno5, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S5  \r\n");    
    } 
    if(strncmp(buf, giorno6, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S6  \r\n");    
    } 
    if(strncmp(buf, giorno7, 3)==0 and strncmp(ora, ora1, 2)==0 and strncmp(minu, min1, 2)==0 and strncmp(ampm, am1, 2)==0)
    {
        printf("Vai a settore S7  \r\n");    
    } 


    if(strncmp(ora, ora2, 2)==0 and strncmp(minu, min2, 2)==0)
    {
        printf("è ora  e minuto Seconda MEDICINA  \r\n");    
    } 

    if(strncmp(ora, ora1, 2)==0)
    {
        printf("è ora medicina 1  \r\n");    
    } 
     
    if(strncmp(minu, min1, 2)==0)
    {
        printf("è minuto  medicina 1  \r\n");    
    }  
 /*                                          
    if(strncmp(ampm, am, 2)==0)
    {
        printf("è mattino  \r\n");    
    }  
     if(strncmp(ampm, pm, 2)==0)
    {
        printf("è pomeriggio  \r\n");    
    }  
*/
    }
}