#include "mbed.h"
#include "TSISensor.h"
//#include "MMA8451Q.h"

//#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void) 
{
//    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    
    PwmOut led1(LED_BLUE);
    PwmOut led2(LED_GREEN);
    PwmOut led3(LED_RED);
    
    float tp = 0;
    //float tp_old = 0;
    float valor_ledR, valor_ledG, valor_ledB = 1.0;
    float valor_inicial, valor_final = 0.0;
    float offset = 0.0;
    float aux = 0.0;
    
    unsigned char led_atual = 0;
    unsigned char ajustando = 0;
    unsigned char efeito = 0;
    unsigned char blink = 0;
    
    TSISensor tsi; //inicializa rotinas do sensor de toque 
   
    led1 = 1.0; //desliga leds
    led2 = 1.0;
    led3 = 1.0;
    
    valor_ledB = led1;
    valor_ledG = led2;
    valor_ledR = led3;

    valor_inicial = 0.0;
    valor_final = 0.0;
        
    efeito = 0;
    
    while (1) 
    {   
        //tp  = (tsi.readPercentage()>0)?tsi.readPercentage():tp;
          
        tp = tsi.readDistance();  //take actual value of touch sensor
                  
        if (tp == 0)              //there is no touch
        {
            
            if(!ajustando)
            {
                valor_inicial = 0.0;
                valor_final = 0.0;
            }
            
            ajustando = 0;          //not adjusting
            
            if(led_atual)           //there is any color selected?
            {
                if(!efeito)
                {
                    led3 = valor_ledR;  //adjust red led 
                    led2 = valor_ledG;  //adjust green led
                    led1 = valor_ledB;  //adjust blue led
                }
            }
            else
            {
                led3 = led2 = led1 = 1.0;   //turn off all colors
            }
        }
          
        if(efeito)
        {
            if(led_atual)
            {
                if(efeito == 1)
                {
                    blink = ~blink;
                    if(blink)
                    {
                        led3 = valor_ledR;  //adjust red led 
                        led2 = valor_ledG;  //adjust green led
                        led1 = valor_ledB;  //adjust blue led
                    }
                    else
                    {
                        led3 = 1.0;  //adjust red led 
                        led2 = 1.0;  //adjust green led
                        led1 = 1.0;  //adjust blue led
                    }
                }
                if(efeito == 2)
                {
                    offset = offset +  0.02;
                    
                    if(offset > 1.0)
                    {
                        offset = 0.0;
                    }
                                            
                    if(valor_ledB < 1.0)
                    {
                        led1 = offset;
                    }
                    if(valor_ledG < 1.0)
                    {
                        led2 = offset;
                    }
                    if(valor_ledR < 1.0)
                    {
                        led3 = offset;
                    }    
                }
                
                if(efeito == 3)
                {
                    offset = offset -  0.02;
                    
                    if(offset < 0.0)
                    {
                        offset = 1.0;
                    }
                                            
                    if(valor_ledB < 1.0)
                    {
                        led1 = offset;
                    }
                    if(valor_ledG < 1.0)
                    {
                        led2 = offset;
                    }
                    if(valor_ledR < 1.0)
                    {
                        led3 = offset;
                    }
                }
                if(efeito == 4)
                {
                    offset = offset -  0.01;
                    
                    if(offset < 0.0)
                    {
                        offset = 1.0;
                    }
                                            
                    led1 = offset;
                    
                    aux = 1 - offset;
                    if(aux < 0.0)
                    {
                        aux = 0.0;
                    }
                    led2 = aux;
                    
                    aux = offset * 2;
                    if(aux > 1.0)
                    {
                        aux = 0.0; 
                    }
                    led3 = aux;
                    
                }
            }
            //wait(0.1);
        }
           
        if((tp > 0) & (tp < 5))   //the colors are select at begin of touch sensor
        {
            if(!ajustando)          //the adjust function is not activeted
            {
                led1 = 1.0;         //turn off all colors
                led2 = 1.0;
                led3 = 1.0;
            
                led_atual++;        //increment actual color selector
            
                if(led_atual > 7)   
                {
                    led_atual = 0;  //turn off leds
                }
                
                if(led_atual == 1)  //selected color is blue
                {
                    led1 = valor_ledB = 0.0;     //turn on blue led
                    led2 = valor_ledG = 1.0;
                    led3 = valor_ledR = 1.0;
                }
                
                if(led_atual == 2)  //selected color is green
                {
                    led1 = valor_ledB = 1.0;
                    led2 = valor_ledG = 0.0;     //turn on green led
                    led3 = valor_ledR = 1.0;
                }
                
                if(led_atual == 3)  //selected color is red
                {
                    led1 = valor_ledB = 1.0;
                    led2 = valor_ledG = 1.0;
                    led3 = valor_ledR = 0.0;     //turn on red led
                }
                
                if(led_atual == 4)
                {
                    led1 = valor_ledB = 0.0;     //turn on blue led and
                    led2 = valor_ledG = 0.0;     //turn on green led
                    led3 = valor_ledR = 1.0;
                }
                
                if(led_atual == 5)
                {
                    led1 = valor_ledB = 0.0;     //turn on blue led and
                    led2 = valor_ledG = 1.0;
                    led3 = valor_ledR = 0.0;     //turn on red led
                }
                
                if(led_atual == 6)
                {
                    led1 = valor_ledB = 1.0;
                    led2 = valor_ledG = 0.0;     //turn on green led
                    led3 = valor_ledR = 0.0;     //turn on red led
                }
                
                if(led_atual == 7)  // select color is white 
                {
                    led1 = valor_ledB = 0.0;     //turn on blue color
                    led2 = valor_ledG = 0.0;     //turn on green color
                    led3 = valor_ledR = 0.0;     //turn on red led
                }
                
                wait(0.5);          //show selected led to user
            }
        }
        
        if (tp > 35)              //superior side
        {
            if(!ajustando)
            {
                efeito++;
                if(efeito > 4)
                {
                    efeito = 0;
                }
            }
            //wait(0.5);
        }
         
        if((tp > 5))    //set the brightness of select color
        {
            if(!ajustando)
            {
                valor_inicial = tp;
            }
            
            ajustando = 1;  //adjusting is true
            
            valor_final = tp;
                
            //led1 = 1.0;     //take off all colors
            //led2 = 1.0;
            //led3 = 1.0;
                  
            if(led_atual == 1)  //selected color is blue
            {
                valor_ledB = valor_ledB + (valor_inicial - valor_final)/200;
                
                if(valor_ledB < 0.0)
                {
                    valor_ledB = 0.0;
                }
                
                if(valor_ledB > 1.0)
                {
                    valor_ledB = 1.0;    
                }
                
                //valor_ledB = (40.0 - tp)/40.0; 
                
                led1 = valor_ledB;          //put new value on blue led
                led2 = valor_ledG = 1.0;    //turn off
                led3 = valor_ledR = 1.0;    //turn off
            }
                
            if(led_atual == 2)  //selected color is green
            {
                //valor_ledG = (40.0 - tp)/40.0; 
                
                valor_ledG = valor_ledG + (valor_inicial - valor_final)/200;
                
                if(valor_ledG < 0.0)
                {
                    valor_ledG = 0.0;
                }
                
                if(valor_ledG > 1.0)
                {
                    valor_ledG = 1.0;    
                }
                
                led1 = valor_ledB = 1.0;    //turn off
                led2 = valor_ledG;          //put new value on green led
                led3 = valor_ledR = 1.0;    //turn off
            }
                
            if(led_atual == 3)  //selected color is red
            {
                //valor_ledR = (40.0 - tp)/40.0; 
                
                valor_ledR = valor_ledR + (valor_inicial - valor_final)/200;
                
                if(valor_ledR < 0.0)
                {
                    valor_ledR = 0.0;
                }
                
                if(valor_ledR > 1.0)
                {
                    valor_ledR = 1.0;    
                }
                
                led1 = valor_ledB = 1.0;    //turn off
                led2 = valor_ledG = 1.0;    //turn off
                led3 = valor_ledR;          //put new value on red led
            }
                
            if(led_atual == 4)
            {
                //valor_ledB = (40.0 - tp)/40.0;      
                
                valor_ledB = valor_ledB + (valor_inicial - valor_final)/200;
                
                if(valor_ledB < 0.0)
                {
                    valor_ledB = 0.0;
                }
                
                if(valor_ledB > 1.0)
                {
                    valor_ledB = 1.0;    
                }
                
                led1 = valor_ledB;                  //put new value on blue led
                led2 = valor_ledG = valor_ledB;     //put new value on green led
                led3 = valor_ledR = 1.0;            //turn off
            }
                
            if(led_atual == 5)
            {
                //valor_ledB = (40.0 - tp)/40.0;
                
                valor_ledB = valor_ledB + (valor_inicial - valor_final)/200;
                
                if(valor_ledB < 0.0)
                {
                    valor_ledB = 0.0;
                }
                
                if(valor_ledB > 1.0)
                {
                    valor_ledB = 1.0;    
                }
                
                led1 = valor_ledB;                  //put new value on blue led
                led2 = valor_ledG = 1.0;            //turn off
                led3 = valor_ledR = valor_ledB;     //put new value on red led
            }
                
            if(led_atual == 6)
            {
                //valor_ledG = (40.0 - tp)/40.0;
                
                valor_ledG = valor_ledG + (valor_inicial - valor_final)/200;
                
                if(valor_ledG < 0.0)
                {
                    valor_ledG = 0.0;
                }
                
                if(valor_ledG > 1.0)
                {
                    valor_ledG = 1.0;    
                }
                
                led1 = valor_ledB = 1.0;            //turn off
                led2 = valor_ledG;                  //put new value on green led
                led3 = valor_ledR = valor_ledG;     //put new value on red led
            }
                
            if(led_atual == 7)  // select color is white 
            {
                //valor_ledB = (40.0 - tp)/40.0;
                
                valor_ledB = valor_ledB + (valor_inicial - valor_final)/200;
                
                if(valor_ledB < 0.0)
                {
                    valor_ledB = 0.0;
                }
                
                if(valor_ledB > 1.0)
                {
                    valor_ledB = 1.0;    
                }
                
                led1 = valor_ledB;                  //put new value on blue led
                led2 = valor_ledG = valor_ledB;     //put new value on green led
                led3 = valor_ledR = valor_ledB;     //put new value on red led
            }
        }
         
        //led1 = (tsi.readPercentage()==0)?(1-abs(acc.getAccX())):((tp>0.00 && tp <= 0.33)?(1-(tp-0.00)*3):1);
        //led2 = (tsi.readPercentage()==0)?(1-abs(acc.getAccY())):((tp>=0.34 && tp <= 0.66)?(1-(tp-0.33)*3):1);
        //led3 = (tsi.readPercentage()==0)?(1-abs(acc.getAccZ())):((tp>=0.67 && tp <= 0.99)?(1-(tp-0.66)*3):1);
          
        wait(0.1);
    }
}