// Display de texto con scrolling
// Basado en: https://github.com/hack-miniblip/hack-miniblip.github.io/tree/master/ejemplos/iluminandoLetras
// Autores: @javacasm, @neon520, @juanAFernandez, @carlosgs

#include "mbed.h"
#include "neopixel.h"

// Matrix led output pin
#define DATA_PIN P0_9

void fill_pixel(neopixel::Pixel buffer[25], int x, int y, int red, int green, int blue){
    
    if(x<0) x=0;
    if(x>4) x=4;
    if(y<0) y=0;
    if(y>4) y=4;
       

    int posicion=x+y*5;
    buffer[posicion].red=red;
    buffer[posicion].green=green;
    buffer[posicion].blue=blue;
    
}

void void_matrix(neopixel::Pixel aux[25], int tam=25){
    
    for(int i=0;i<tam;i++){
        aux[i].red=0;
        aux[i].green=0;
        aux[i].blue=0;
    }
}

//r: intensidadRojo
//g: intensidadVerde
//b: intensidadAzul
void generaLetra(neopixel::Pixel vector[], char letra, int red, int green, int blue, int scroll){

    /*
    * Cada letra tiene 5 valores en hexadecimal que representan en binario cada fila de la matrix 5x5 (aunque sobren 3 bits)
    */
    unsigned char espacio[5]={0x0, 0x0, 0x0, 0x0, 0x0};
    unsigned char a[5]={0x88, 0x88, 0xF8, 0x88, 0x70};
    unsigned char b[5]={0xF0, 0x88, 0xF0, 0x88, 0xF0};      
    unsigned char c[5]={0x78, 0x80, 0x80, 0x80, 0x78};   
    unsigned char d[5]={0xF0, 0x88, 0x88, 0x88, 0xF0};
    unsigned char e[5]={0xF8, 0x80, 0xF8, 0x80, 0xF8};
    unsigned char f[5]={0x80, 0x80, 0xE0, 0x80, 0xF8};    
    unsigned char g[5]={0x78, 0x88, 0xB8, 0x80, 0x78};
    unsigned char h[5]={0x88, 0x88, 0xF8, 0x88, 0x88};
    unsigned char i[5]={0x70, 0x20, 0x20, 0x20, 0x70};
    unsigned char j[5]={0x70, 0x88, 0x8,  0x8,  0x38};
    unsigned char k[5]={0x88, 0x88, 0xF0, 0xA0, 0x90}; 
    unsigned char l[5]={0xF8, 0x80, 0x80, 0x80, 0x80};
    unsigned char m[5]={0x88, 0x88, 0xA8, 0xD8, 0x88};
    unsigned char n[5]={0x98, 0xA8, 0xA8, 0xA8, 0xC8};
    unsigned char gn[5]={0x98, 0xA8, 0xA8, 0xA8, 0xC8};         // es la ñ
    unsigned char o[5]={0x70, 0x88, 0x88, 0x88, 0x70};
    unsigned char p[5]={0x80, 0x80, 0x78, 0x88, 0x78};
    unsigned char q[5]={0x78, 0x90, 0x90, 0x90, 0x60};
    unsigned char r[5]={0x88, 0x90, 0xF0, 0x88, 0xF0};    
    unsigned char s[5]={0xF0, 0x8,  0x70, 0x80, 0x78};
    unsigned char t[5]={0x20, 0x20, 0x20, 0x20, 0xF8};
    unsigned char u[5]={0x70,0x88,0x88,0x88,0x88};
    unsigned char v[5]={0x20,0x50,0x50,0x88,0x88};
    unsigned char w[5]={0x88,0xD8,0xA8,0x88,0x88};
    unsigned char x[5]={0x88,0x50,0x20,0x50,0x88};
    unsigned char y[5]={0x20,0x20,0x70,0x88,0x88};
    unsigned char z[5]={0xF8,0x80,0x70,0x8,0xF8};
        
    
    //unsigned char l0[0]=
    
        
    //Montamos un vector de vectores:
    unsigned char *vectorPunteros []={a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z};
            
    //Con la letra recibida le restamos 26 y tenemos la posicion del vector.                        
    //Para moverlo por los vectores.  
    unsigned char *puntero; 
    if (letra==32) //Se trata de un espacio         
        puntero=espacio;
    else              
        //a= al valor 97
        puntero=vectorPunteros[(letra-'a')];
    
        
            //Vamos a recorrer todo el vector de bytes
            for(int i=0; i<5; i++){
                
                unsigned char elemento = puntero[i];
                unsigned int mask=0x80;
                //Nos movemos por 5 bits de los 8
                for(int x=0; x<5; x++){
                    if (elemento & mask)
                        if(x+scroll >= 0 && x+scroll < 5)
                            fill_pixel(vector, x+scroll,i, red, green, blue);                                                                
                    //Desplazamos 1 bit
                    mask >>=1;
                }                
            }          
}    

void iluminaTexto(char cadena[], neopixel::PixelArray array, int r, int g, int b){
      
       //Creamos un vector de pixeles.
       neopixel::Pixel letra[25];
        //Inicializamos el vector a 0
        void_matrix(letra);
        
        char letraAnterior = ' ';
        
        for(int i=0; i<strlen(cadena); i++){
            
            for(int scroll=0; scroll<7; scroll++){
                //Generamos la letra en el vector letra        
                generaLetra(letra, letraAnterior, r, g, b, -scroll-2);
                generaLetra(letra, cadena[i],     r, g, b,  5-scroll);
                //Iluminamos la matriz
                array.update(letra, 25);
                //Esperamos
                wait_ms(60);
                //Reseteamos la matriz
                void_matrix(letra);
            }
            letraAnterior = cadena[i];
        }
        
        
}    

PwmOut speaker(P0_8);

int main()
{
    // Turn off miniblip buzzer
    speaker=0.0;
    
    // Create a temporary DigitalIn so we can configure the pull-down resistor.
    DigitalIn(DATA_PIN, PullDown);

    // The pixel array control class.
    //Se está creando un objeto de tipo PixelArray y se está nombrando como array a la que se le está pasando DATA_PIN
    neopixel::PixelArray array(DATA_PIN); 
    
    char greeting[] = "hola mundo ";

    while (1) {
        int r = 0;
        int g = rand()%30;
        int b = rand()%30;
        
        if (rand()%10 < 3){
            r = rand()%30;
            g = 0;
            b = 0;
        }
        
        iluminaTexto(greeting, array, r,g,b);
        wait_ms(500);
    }
}
