/* ********************************************
* PCD8544 Driver
* This is a sample program to interface the
* mbed microcontroller to an LCD with an PCD8544
* driver using the pcd8544_drv library.
*
* Created on: 12/31/2010 at 19:48
* Created by: CarlosFTM
********************************************** */


#include "mbed.h"
#include "pcd8544_drv.hpp"

DigitalOut myled(LED1);

int main()
{
  /* Create a LCD interface*/
  pcd8544 lcd(p21, p22, p23, p24, p27);

  /* Initialize LCD & Clear screen*/
  lcd.resetLCD();
  lcd.initLCD();
  lcd.clearLCD();
  wait(0.5);

  /* Fill the screen with a single character (14 * 6 = 84 characters) */
  char count;
  for (count = 0; count < (MAX_CHAR_X * MAX_CHAR_Y); count++)
  {
    lcd.writeChar('#');
  }

  /* Locate the cursor on line 3 and print a char string */
  char message[] = ">PCD8544 LCD>";   // Define message string
  char* message_p = message;         // Create a pointer
  
  lcd.setCursorXY(1,2);              // Locate the cursor on line 3
                                     // (Line/Column count starts at 0)
  
  lcd.writeString(message_p);        // Write the string on the LCD
  
  /* Flash LED
   * in infinite loop
   */
  while(1)
  {
    myled = !myled;
    wait(0.05);
    myled = !myled;
    wait(0.5);
  }
}
