#include "ProcessInterface.hpp"

ProcessInterface::ProcessInterface() : Output(0), cmd(0), processRead(P0_4), cmdPin(P0_0) {
	this->Ctrl = 0;
	this->Btd = 0;
	cmdPin.period(MIN_PWM_PERIOD);
}

ProcessInterface::ProcessInterface(PinName _analogPin, PinName _pwmPin) : Output(0), cmd(0), processRead(_analogPin), cmdPin(_pwmPin) {
	this->Ctrl = 0;
	this->Btd = 0;
	cmdPin.period(MIN_PWM_PERIOD);
}

void ProcessInterface::attachController(Controller *_Ctrl) {
	Ctrl = _Ctrl;
}

void ProcessInterface::attachBTDevice(BTDevice *_Btd) {
	Btd = _Btd;
}

void ProcessInterface::getProcOutput() {
	Output = processRead.read();
}

void ProcessInterface::exportOutput() {
	Ctrl->updateOut(Output);
	Btd->updateOut(Output);
}

void ProcessInterface::updateCmd() {
	cmd = Ctrl->getCmd();
}

void ProcessInterface::updateCmd(float _cmd) {
	cmd =_cmd;
}

void ProcessInterface::applyCmd() {
	cmdPin.write(cmd);	
}


ProcessInterface::~ProcessInterface() {
	delete Ctrl;
	delete Btd;
}
