#include "BTDevice.hpp"

BTDevice::BTDevice(): 
	txCharacteristic(uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE), 
	rxCharacteristic(uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
	uartService(uart_base_uuid, uartChars, sizeof(uartChars)/sizeof(GattCharacteristic *)),
	pc(USBTX, USBRX),
	ble()	 
{	
	this->ctrl = 0;
    memset(this->txPayload, 0, TXRX_BUF_LEN);
    memset(this->rxPayload, 0, TXRX_BUF_LEN);
    memset(this->rx_buf, 0, TXRX_BUF_LEN);
    this->rx_len = 0;
    uartChars[0] = &txCharacteristic;
    uartChars[1] = &rxCharacteristic;
}

BTDevice::~BTDevice() { 
	delete this->ctrl; 
} 

void BTDevice::init() {
	//this->ble = BLE::Instance();
	ble.init(this, &BTDevice::initCallback);
}

void BTDevice::waitForEvent() {
	this->ble.waitForEvent();
}

void BTDevice::getPayload(uint8_t *buff) {
	int i;
	for (i = 0; i < TXRX_BUF_LEN; i++)	{
		buff[i] = this->txPayload[i];
	}
    memset(this->txPayload, 0, TXRX_BUF_LEN);
}

void BTDevice::initCallback(BLE::InitializationCompleteCallbackContext *params) {
	// BLE&        ble   = params->ble;
	// this->ble = params->ble;
    ble_error_t error = params->error;
	
    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
//        onBleInitError(this->ble, error);
        return;
    }
 
    /* Ensure that it is the default instance of BLE */
    if(this->ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
	
	/* set callbacks */
	this->ble.onDataWritten(this, &BTDevice::dataWriteCallback);
	this->ble.onDisconnection(this, &BTDevice::disconnectionCallback);
	
	this->pc.baud(9600);
	this->pc.attach(this, &BTDevice::uartCallback, pc.RxIrq);
 
    /* setup advertising */
    this->ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    this->ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME, (uint8_t *)"Gigel", sizeof("Gigel")-1);
    this->ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    this->ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    this->ble.setAdvertisingInterval(160);

	this->ble.addService(uartService);
	
    this->ble.startAdvertising();
}

	// void BTDevice::disconnectionCallback(const BLE::DisconnectionCompleteCallbackContext *params) {
		
		// pc.printf("Disconnected \r\n");
		// pc.printf("Restart advertising \r\n");
		// this->ble.startAdvertising();
		
	// } //TODO if needed	




void BTDevice::dataWriteCallback(const GattWriteCallbackParams *params) {
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead;
    
    if (params->handle == txCharacteristic.getValueAttribute().getHandle()) {
        this->ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memcpy(this->txPayload, buf, TXRX_BUF_LEN);
        //decode();
        //WriteBuffer(GlobalCommand);
        // conn_state_machine(&buf[0], &buf[1]);
    }
}

void BTDevice::disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
	//TODO	
}

void BTDevice::uartCallback(void) {
	
	while(pc.readable()) {
        this->rx_buf[rx_len++] = pc.getc();    
        if(this->rx_len >= 20 || this->rx_buf[rx_len-1] == '\0' || this->rx_buf[rx_len-1] == '\n') {
            this->ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
            this->rx_len = 0;
            break;
        }
    }
	
}

void BTDevice::sentMsg(uint8_t *msg) {
	this->ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), msg, TXRX_BUF_LEN);
}

bool BTDevice::isInit() {
	return this->ble.hasInitialized();
}

void BTDevice::attachController(Controller *c) { 
	ctrl = c; 
}

void BTDevice::setCtrlRef(float ref) {
	this->ctrl->updateRef(ref);
}

void BTDevice::setCtrlParams(ControllerParams &cp) {
	this->ctrl->updateParams(cp);
}

void BTDevice::updateOut(float _out) {
	out = _out;	
}

bool BTDevice::ctrlExists() {
	return 0 == this->ctrl;
}

Controller* BTDevice::getCtrl() {
	return this->ctrl;
}

/*
void BTDevice::interpretCmd(uint8_t cmd[TXRX_BUF_LEN]) {

// ex:
// ctrl<PI>_create<>
// ctrl<PI>_updateParams<4.5,1>
// ctrl<PI>_updateRef<10>

SysObj obj;
SysObjTypes type;
Action act;
uint8_t actionParams[TXRX_BUF_LEN];

getTokens(*this, &obj, &type, &act);

// this->getTokens(cmd,&obj,&objType,&action,&actionParam);

// ControllerFactory cf;

// state machine for commands
// ...
// ex:
// if("ctrl"==obj && action=="create") {
	// Controller *c = cf.createController(objType);
	// this->attachController(c); //currentCtrl = c;
// }

// else if("ctrl"==obj && action=="updateParams") {
	// ControllerParams cp = cf.createCtrlParams(objType,actionParams);
	// this->setCtrlParams(cp);
// }

// else if("ctrl"==obj && action=="updateRef") {
	// this->setCtrlRef(actionParams);	
// }
// ....

}


friend void getTokens(uint8_t cmd[TXRX_BUF_LEN], BTDevice &bt, SysObj &obj, SysObjTypes &type, Actions &act, uint8_t actionParams[TXRX_BUF_LEN]) {}
*/
