#include "BTDevice.hpp"
#include "ProcessInterface.hpp"

//#define TE	0.1f //minim!!! - o cuanta!! - va fi multiplu al perioadei de esantionare configurabila
//TODO - de folosi RTOS timer in loc de Ticker pentru a avita folosirea ISR pentru functii periodice


static Ticker controlLoopTicker, cmdTicker;
static ProcessInterface pInt;
static BTDevice bt;

void cmdCall(void);
void controlLoopCall(void);

int main () {
	
	bt.init();
	// while (!bt.isInit()) {}
	
	cmdTicker.attach(cmdCall, TE);
	controlLoopTicker.attach(controlLoopCall, (TE+0.05f));
	//bt.attachProcessInterface(pInt);
	
	Controller *myCtrl;
	ControllerFactory cf;
	cf.createController( &myCtrl, PID );
	bt.attachController( myCtrl );
	pInt.attachBTDevice( &bt );
	pInt.attachController( bt.getCtrl() );
	
	while (bt.isInit()) {
		bt.waitForEvent();
	}
	
	return 0;
}

// DE VAZUT CALLBACKUL DE RECEIVE
void cmdCall() {
	uint8_t cmd[TXRX_BUF_LEN];
	bt.getPayload(cmd);
	//bt.interpretCmd(cmd);		//only configuration commands!! (like PID Params of reference update)
}

void controlLoopCall() {
	
	//STATE_MACHINE: CONTROLLER, MANUAL, MONITOR ETC 
	//we check if a controller exists (was prev set by a command)
	if (bt.ctrlExists()) {
		// controllers were attached in the command Callback to btDevice and ProcessInterface
		pInt.getProcOutput();
		pInt.exportOutput();
		bt.getCtrl()->calculateCmd();
		pInt.updateCmd();		// no parameters means that we get the updated command from the Controller instance
		pInt.applyCmd();
	} else {
		pInt.updateCmd(0.0f);	// we directly pass the command value
		pInt.applyCmd();
	}
}
