#ifndef CONTROLLER_H
#define CONTROLLER_H

#include "ControllerParams.hpp"
#include "stdint.h"

using namespace std;

class Controller {
	protected:	
		float ref;
		float out;
		float cmd;

	public:
		virtual void calculateCmd(void) = 0;
		virtual void updateParams(ControllerParams&) = 0;
		virtual ~Controller();	
	
		void updateRef(float);	
		void updateOut(float);

		float getCmd();
};

#endif
