#ifndef _BTdevice_
#define _BTdevice_

#include <Gap.h>
#include "ble/BLE.h"
#include "Controller.hpp"
#include "ControllerParams.hpp"
#include "ControllerFactory.hpp"
#include "CmdEnums.hpp"
#include "mbed.h"

#define TXRX_BUF_LEN	20

static const uint8_t uart_base_uuid[] = 	 {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = 	 {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = 	 {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] =  {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

class BTDevice {
	
	public:
		BTDevice();
		void init();
		bool isInit();
		void waitForEvent();
		void getPayload(uint8_t *);
		void sentMsg(uint8_t *);
		
		bool ctrlExists(); 
		Controller* getCtrl();
		void attachController(Controller *c);
		void setCtrlRef(float);
		void setCtrlParams(ControllerParams &cp);
		void updateOut(float);

		//void interpretCmd(uint8_t cmd[TXRX_BUF_LEN]);
		~BTDevice();
		

	//friend void getTokens(uint8_t cmd[TXRX_BUF_LEN], BTDevice&, SysObj&, SysObjTypes&, Actions&, uint8_t actionParams[TXRX_BUF_LEN]);
	
	
	private:
		GattCharacteristic txCharacteristic;
		GattCharacteristic rxCharacteristic;
		GattCharacteristic* uartChars[2];
		GattService uartService;
		Serial pc;
	
		BLE ble;
		uint8_t txPayload[TXRX_BUF_LEN];
		uint8_t rxPayload[TXRX_BUF_LEN];
		uint8_t rx_buf[TXRX_BUF_LEN];
		uint8_t rx_len;
		
		Controller* ctrl;
		float out;
		
		void initCallback(BLE::InitializationCompleteCallbackContext *);
		// void connectionCallback(const BLE::ConnectionCompleteCallbackContext *params) {} //TODO if needed	
		void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *); //TODO if needed	
		void dataWriteCallback(const GattWriteCallbackParams *);
		void uartCallback(void);
		
};

#endif
