/*Copy of Temp_blended_v0 is 200 reading of the sensor displayed on a terminal monitor over a USB link
*/
#include "mbed.h"
#include "mlx90614.h"

DigitalOut myled(LED1); //displays I2C wait
DigitalOut EXON(LED4);  //added signal to indicated external input voltage is present
DigitalIn exin(p20);    //added input location for external signal
I2C i2c(p28,p27);   //set up pins for I2C sda,scl
Serial pc(USBTX,USBRX);  //serial usb config for terminal display program

MLX90614 IR_thermometer(&i2c);
//setup an MLX90614 using MLX90614 library from
// ://mbed.org/users/aquahika/libraries/MLX90614/lsixz6
float temp; //temperature in degrees C 
int count =0; //way to count # of temp reading...

int main() {
    while(1) {
        if (count<200){
            myled=1; // if led1 on - waiting on I2C
        
            if (IR_thermometer.getTemp(&temp)) {
                        //gets temperature from sensor via I2C bus
            printf("%u %5.2F %5.2F \r\n", count, temp, (temp*1.8 + 32)); //used to print No., C , F temperature in text CVS file
            }//closes 2nd IF
         myled=0;
         count++;   
    }//closes 1st If
    EXON = exin;  //Should turn on led if positive voltage present
   }//closes while 1
   //EXON = exin;  //Should turn on led 
}//closes main
