/*test program to learn how to write code for a 4 digit, 7-segment LED display LDQ-N524R1
The schematic for this (COMMON CATHODE) display shows the following connections
schematic located at http://www.lumex.com/ldq-n514ri (open Specs PDF for drawing)
The Common Cathode means that to turn on the segments of the 7-segment (including decimal point)
you write a one to that segment.
For this 4 digit display (LDQ-N524R1), each digit works backward--like its wired Common Anode so
You write a ZERO to turn on the selected digit AND a ONE to turn off the digit.

Pin Out wiring guide:(connect the display pin # to XX mbed pin)

CONTROL   DISPLAY Pin#  MBED Pin#
----------------------------------
Digit1          12         14
Digit2          9          13
Digit3          8          12
Digit4          6          11
DP              3          10
A               11         21
B               7          22
C               4          23
D               2          24  
E               1          25 
F               5          26
G               5          27

There is no blanking on this display, 

Program demonstrates use of BusOut to control segments of 7-segment display for 4 digit display LDQ-N514R1  
Author: Cap'n Tim Johnson PE
Retired Professor
Wentworth Institude of Technology 
Dept. Electrical Engineering and Technology
Boston, MA
*/

#include "mbed.h"

BusOut myleds(LED1, LED2, LED3, LED4);  //adding a common cathode bus to contrast with Digits bus
//LED1 is next to pin 20
BusOut Segments(p21,p22,p23,p24,p25,p26,p27,p10);  //8-bit bus MSB is pin 21--the "a" segment
BusOut Digits(p14, p13, p12, p11);  //4 bit digit control bus with digit 1 (pin 14) on left then in decreasing order
//But to turn on MSD, write a zero to bit 0 of the bus...0x1110 or 14 decimal 
//the bit order is reversed from the written order for Digits bus as with the Segment bus

//writing decimal to Digits bus:
//binary 1111, decimal 15 turns off the digits 
//binary 1110, decimal 14 turns on digit 1 (MSD)
//binary 1101, decimal 13 turns on digit 2 (2nd from left)
//binary 1100, decimal 12 turns on the 2 MSD
//binary 1011, decimal 11 turns on digit 3  (3rd from left)
//binary 0111, decimal 7  turns on digit 4 (LSD)

int i = 1;  //used to set wait time
int main() {
  //  while (1){  //used to turn off loop  

            wait (i);
            myleds = 15;     //turns on all the signal LEDs 
            Segments = 255; //decimal #255 write ones to every bit in Segment bus--turn on all 7-segments + DP
            Digits = 0;    //turn on all digits (digit wired common anode--opposite of segments bus
            wait (i);
            myleds = 0;     //turning of the signal LEDs
            Digits = 15;   //turn off the digits
            wait (i);
            myleds = 1;     //turns on LED1 
            Digits = 14;    //turn on just one digit, MSD, left-most digit
            wait (i);
            myleds = 3;     //turning on 2 signal LEDs
            Digits = 12;    //turn on two digits
            wait (i);
            myleds = 7;     //turning on 3 signal LEDs
            Digits = 8;     //turn on 3 digits
            wait (i);
            myleds = 15;    //turning on all for digits
            Digits = 0;    //turn on 4 digits
            wait (i);
            myleds = 0;    //turning off all for signal LEDs and ending this comparison of REVERSE LOGIC
            Digits = 15;   //turn off all 4 digits
            wait (i);   
            Segments = (7); //turn on the number 7 for all four
            Digits = 0;     //turn on all 4 digits
            wait (i);
            Digits =15;     //turn off all 4 digits
            wait (i);
            Segments = (63);  //turn them on as zeros
            Digits =0;        //turn on the 4 digits
            wait (i);  
            Digits = 15;     //turn off the 4 digits
            Segments=0;      //turn off the segments
            wait (i);        //wait with everything dead
            Segments = 128;  //Turn on the decimal points 
            Digits = 0;      //turn on the digits
            wait (i);
            Digits = 0;
 
//        }  //remove leading slashes to enable looping
 //  */ 
}

  