#include "mbed.h"

 /*test program to learn how to write code for a 4 digit, 7-segment LED display LDQ-N524R1
The schematic for this (COMMON CATHODE) display shows the following connections
schematic located at http://www.lumex.com/ldq-n514ri (open Specs PDF for drawing)
The Common Cathode means that to turn on the segments of the 7-segment (including decimal point)
you write a one to that segment.
For this 4 digit display (LDQ-N524R1), each digit works backward--like its wired Common Anode so
You write a ZERO to turn on the selected digit AND a ONE to turn off the digit.

Pin Out wiring guide:(connect the display pin # to XX mbed pin)

CONTROL   DISPLAY Pin#  MBED Pin#
----------------------------------
Digit1          12         14
Digit2          9          13
Digit3          8          12
Digit4          6          11
DP              3          10
A               11         21
B               7          22
C               4          23
D               2          24  
E               1          25 
F               5          26
G               5          27

There is no blanking on this display, 
Program demonstrates writing to all four digits of the 7-segment LED display of the LDQ-N514R1 a decimal number
Since the segments only light up for one selected digit, all 4 digit has to be flashed to show 4 separate numbers
Television used this by flashing 30 screens per second call persistence enhanced cathode ray tubes.

Author: Cap'n Tim Johnson PE
Retired Professor
Wentworth Institude of Technology 
Dept. Electrical Engineering and Technology
Boston, MA
*/

//Setup:
DigitalOut Digit1(p14);  //construct to control digits
DigitalOut Digit2(p13);
DigitalOut Digit3(p12);
DigitalOut Digit4(p11);
DigitalOut myled (LED1);  //Signal used for runtime checking

//these are the pins associated with writing to the "led"
DigitalOut led[8]={p21, p22, p23, p24, p25, p26, p27, p10};

//segments are in alphabetical order a-g, followed by Decimal point in the array below
    
int matrix[11][8]={
                    {1,1,1,1,1,1,0,0},          //zero
                    {0,1,1,0,0,0,0,0},          //one
                    {1,1,0,1,1,0,1,0},          //two
                    {1,1,1,1,0,0,1,0},          //three
                    {0,1,1,0,0,1,1,0},          //four
                    {1,0,1,1,0,1,1,0},          //five
                    {1,0,1,1,1,1,1,0},          //six
                    {1,1,1,0,0,0,0,0},          //seven
                    {1,1,1,1,1,1,1,0},          //eight
                    {1,1,1,0,0,1,1,0},          //nine
                    {0,0,0,0,0,0,0,1}          //dot
                  };

//create matrix to handle decimal point
int matrixdecimal[11][8]={
                    {1,1,1,1,1,1,0,1},          //zero
                    {0,1,1,0,0,0,0,1},          //one
                    {1,1,0,1,1,0,1,1},          //two
                    {1,1,1,1,0,0,1,1},          //three
                    {0,1,1,0,0,1,1,1},          //four
                    {1,0,1,1,0,1,1,1},          //five
                    {1,0,1,1,1,1,1,1},          //six
                    {1,1,1,0,0,0,0,1},          //seven
                    {1,1,1,1,1,1,1,1},          //eight
                    {1,1,1,0,0,1,1,1},          //nine
                    {0,0,0,0,0,0,0,1}          //dot...actually a leading null space
                  };

//set persistance (wait value on digits or flash rate)
float f = 0.005;
//enter a float number here (with a decimal in it) starting point
volatile float temp = 31.45;
int t = temp * 100;

int main(){
while (1){
//finessing the digits out one at a time knowing 2nd digit has the decimal
//int tempasinteger = temp * 100;  //removes decimal and typecasts float to integer
int temp1a = t/1000;    //typecast float to integer for 1st digit (was)
int temp2 = t - temp1a*1000;  //gets last 3 digits
int temp2a = temp2/100;   //typecast float to integer for 2nd digit
int temp3 = temp2 - temp2a*100;  //get last 2 digits

int temp3a=temp3/10;    //typecast float to integer for 3rd digit 
int temp4=temp3-temp3a*10;   //gets last digit  
int temp4a = temp4;     //convenient renaming for writing digit to display

//begin one write of the display by turning off all the digits    
    Digit1 = 1; //turn off digit1
    Digit2 = 1; //turn off digit2
    Digit3 = 1; //turn off digit3
    Digit4 = 1; //turn off digit4
//    while (1) {       
        //turns off last led's segments values
        for(int i = 0; i<8;i++){
            led[i] = 0;}
         //belows holds row of matrix and assign column value from matrix
         Digit1 = 0;             //turns on digit1
            for (int i=0; i<8; i++){
                led[i] = matrix[temp1a][i];
                }  
        wait(f);
        Digit1=1;
        
     //turns off last led's segments values
        for(int i = 0; i<8;i++){
            led[i] = 0;}
         //belows holds row of matrix and assign column value from matrix
         Digit2 = 0;             //turns on digit2 with decimal
            for (int i=0; i<8; i++){
                //since we have prior knowledge of the decimal location 
                //and this is a demonstration program, we add the decimal for this digit
                led[i] = matrixdecimal[temp2a][i];
                } 
        wait(f);
        Digit2=1;
                    
     //turns off last led's segments values
        for(int i = 0; i<8;i++){
            led[i] = 0;}
         //belows holds row of matrix and assign column value from matrix
         Digit3 = 0;             //turns on digit3
            for (int i=0; i<8; i++){
                led[i] = matrix[temp3a][i];
                }             
        wait(f);
        Digit3=1;
        
             //turns off last led's segments values
        for(int i = 0; i<8;i++){
            led[i] = 0;}
         //belows holds row of matrix and assign column value from matrix
         Digit4 = 0;             //turns on digit4
            for (int i=0; i<8; i++){
                led[i] = matrix[temp4a][i]; 
                } 
        wait(f);
        Digit4=1;
        
        //loop & increment
        if (t <3600) 
        t=t+1;
        else
        t=3200;
        
        
      }  //close for while 1
} //close for main