#include "mbed.h"

 /*test program to learn how to write code for a 4 digit, 7-segment LED display LDQ-N524R1
The schematic for this (COMMON CATHODE) display shows the following connections
schematic located at http://www.lumex.com/ldq-n514ri (open Specs PDF for drawing)
The Common Cathode means that to turn on the segments of the 7-segment (including decimal point)
you write a one to that segment.
For this 4 digit display (LDQ-N524R1), each digit works backward--like its wired Common Anode so
You write a ZERO to turn on the selected digit AND a ONE to turn off the digit.

Pin Out wiring guide:(connect the display pin # to XX mbed pin)

CONTROL   DISPLAY Pin#  MBED Pin#
----------------------------------
Digit1          12         14
Digit2          9          13
Digit3          8          12
Digit4          6          11
DP              3          10
A               11         21
B               7          22
C               4          23
D               2          24  
E               1          25 
F               5          26
G               5          27

There is no blanking on this display, 

Program demonstrates writing to one 7-segment display of 4 digit display LDQ-N514R1  
Author: Cap'n Tim Johnson PE
Retired Professor
Wentworth Institude of Technology 
Dept. Electrical Engineering and Technology
Boston, MA
*/

//Setup:
DigitalOut Digit1(p14);  //construct to control digits
DigitalOut Digit2(p13);
DigitalOut Digit3(p12);
DigitalOut Digit4(p11);

//these are the pins associated with writing to the "led"
DigitalOut led[8]={p21, p22, p23, p24, p25, p26, p27, p10};

//segments are in alphabetical order a-g, followed by Decimal point in the array below
    
int matrix[11][8]={
                    {1,1,1,1,1,1,0,0},          //zero
                    {0,1,1,0,0,0,0,0},          //one
                    {1,1,0,1,1,0,1,0},          //two
                    {1,1,1,1,0,0,1,0},          //three
                    {0,1,1,0,0,1,1,0},          //four
                    {1,0,1,1,0,1,1,0},          //five
                    {1,0,1,1,1,1,1,0},          //six
                    {1,1,1,0,0,0,0,0},          //seven
                    {1,1,1,1,1,1,1,0},          //eight
                    {1,1,1,0,0,1,1,0},          //nine
                    {0,0,0,0,0,0,0,1}          //dot
                  };


int main() {
    Digit1 = 1; //turn all digit1 in case they've been turned on...in another program  
    Digit2 = 1; //turn off digit2
    Digit3 = 1; //turn off digit3
    Digit4 = 1; //turn off digit4
    
    Digit1 = 0; //Turn on digit#1, Most Significant Digit
    while (1) {
            //all led's off
        for(int i = 0; i<8;i++){led[i] = 0;}
        
            //display shows the number in this case 6
        for (int i=0; i<8; i++){led[i] = matrix[6][i];}  //holds row of "number" and assign column value from matrix
               wait(0.5);
    
    }
}
