#include "main.h"

//#define DEBUG

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
DigitalOut myled(LED1);
QSPI_DISCO_F746NG qspi;

Serial pc(USBTX, USBRX); // DEBUG

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    led_on();
    wait(0.2);

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    wait(0.2);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    led_off();
    
    // Check initialization
    QSPI_Info pQSPI_Info;
    uint8_t WriteBuffer[BUFFER_SIZE] = "Hello World !!!";
    uint8_t ReadBuffer[BUFFER_SIZE];
    
    #ifdef DEBUG
    pc.printf("\n\nQSPI demo started\n\r");
    #endif // DEBUG
    
    uint8_t init_return = qspi.Init();
    
    #ifdef DEBUG
    pc.printf("Init return value: %d\n\r", init_return);
    #endif // DEBUG
    
    if (init_return != QSPI_OK)
    {
        #ifdef DEBUG
        pc.printf("QSPI Initialization FAILED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI Initialization FAILED", CENTER_MODE);
    }
    else
    {
        #ifdef DEBUG
        pc.printf("QSPI Initialization PASSED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI Initialization PASSED", CENTER_MODE);
    }
    
    wait(2);
    
    // Check memory informations
    qspi.GetInfo(&pQSPI_Info);
    if ((pQSPI_Info.FlashSize          != N25Q128A_FLASH_SIZE) ||
        (pQSPI_Info.EraseSectorSize    != N25Q128A_SUBSECTOR_SIZE) || 
        (pQSPI_Info.ProgPageSize       != N25Q128A_PAGE_SIZE) ||
        (pQSPI_Info.EraseSectorsNumber != N25Q128A_SUBSECTOR_SIZE) ||
        (pQSPI_Info.ProgPagesNumber    != N25Q128A_SECTOR_SIZE))
    {
        #ifdef DEBUG
        pc.printf("QSPI informations FAILED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI informations FAILED", CENTER_MODE);
    }
    else
    {
        #ifdef DEBUG
        pc.printf("QSPI informations PASSED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI informations PASSED", CENTER_MODE);
    }
    
    wait (2);
    
    // Erase memory
    if (qspi.Erase_Block(WRITE_READ_ADDR) != QSPI_OK)
    {
        #ifdef DEBUG
        pc.printf("QSPI erase FAILED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI erase FAILED", CENTER_MODE);
    }
    else
    {
        #ifdef DEBUG
        pc.printf("QSPI erase PASSED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI erase PASSED", CENTER_MODE);
    }
    
    wait (2);
    
    // Write memory
    if (qspi.Write(WriteBuffer, WRITE_READ_ADDR, 15) != QSPI_OK)
    {
        #ifdef DEBUG
        pc.printf("QSPI write FAILED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI write FAILED", CENTER_MODE);
    }
    else
    {
        #ifdef DEBUG
        pc.printf("QSPI write PASSED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI write PASSED", CENTER_MODE);
    }
    
    wait (2);
    
    // Read memory
    if (qspi.Read(ReadBuffer, WRITE_READ_ADDR, 11) != QSPI_OK)
    {
        #ifdef DEBUG
        pc.printf("QSPI read FAILED\n\r");
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI read FAILED", CENTER_MODE);
    }
    else
    {
        #ifdef DEBUG
        pc.printf("QSPI read PASSED - [%s]\n\r", ReadBuffer);
        #endif // DEBUG
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        //lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"QSPI read PASSED", CENTER_MODE);
        
        sprintf((char*)text, "QSPI read PASSED - [%s]\n\r", ReadBuffer);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)&text, CENTER_MODE);
    }
    
    wait (2);

    
    while(1) {
        
        lcd.SetBackColor(LCD_COLOR_BLUE);
        lcd.SetTextColor(LCD_COLOR_WHITE);

        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                
            }

            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
            
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLUE);
                sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
                
                cleared = 1;
            }
        }
        
       
        // Touch detection of one button
        if (TS_State.touchDetected > 0) {
            }
        else {
            }
    }
}


// Functions definition
void led_power (int state) {
    myled = state;
    }

void led_on (void) {
    led_power(1);
    }
    
void led_off (void) {
    led_power(0);
    }
    
void led_toggle (void) {
    static int toggle = 0;
    if (toggle) {
        led_on();
        toggle = 0;
        }
    else {
        led_off();
        toggle = 1;
        }
    }


