/**
 *    ||          ____  _ __  ______
 * +------+      / __ )(_) /_/ ____/_________ _____  ___
 * | 0xBC |     / __  / / __/ /    / ___/ __ `/_  / / _ \
 * +------+    / /_/ / / /_/ /___ / /  / /_/ / / /_/  __/
 *  ||  ||    /_____/_/\__/\____//_/   \__,_/ /___/\___/
 *
 * Crazyflie control firmware
 *
 * Copyright (C) 2011-2012 Bitcraze AB
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SENSORFUSION9_H_
#define SENSORFUSION9_H_
#include <stdbool.h>


#ifdef __cplusplus
extern "C" {
#endif

void sensfusion9Init(void);
bool sensfusion9Test(void);

void sensfusion9UpdateQ(float gx, float gy, float gz, float ax, float ay, float az, float mx, float my, float mz, float dt);
void sensfusion9GetEulerRPY(float* roll, float* pitch, float* yaw);
void sensfusion9GetQuaternion(float* Q0, float* Q1, float* Q2, float* Q3);
float sensfusion9GetAccZWithoutGravity(const float ax, const float ay, const float az);
float sensfusion9GetInvThrustCompensationForTilt();

#ifdef __cplusplus
}
#endif

#endif /* SENSORFUSION9_H_ */
