#include "mbed.h"
#include "MFRC522.h"
#include "ESP8266.h"

#define IP "104.196.113.161" // Domoti Server IP Address
#define PORT "6666" // Domoti Server IP Address
char snd[255],rcv[100];
char *spr;
char UIDstr[10];
uint8_t dir;

Serial pc(SERIAL_TX, SERIAL_RX);

MFRC522 *rf_in;
MFRC522 *rf_out;

ESP8266 wifi(PA_11, PA_12, 9600); // baud rate for wifi

DigitalOut ESP_Enable(PB_12);
DigitalOut ESP_Reset(PA_7);
DigitalOut green(PA_5);

void connect() {
    green = 1;
    while (1) {
        wifi.Join("DOMOTI_EXT", "domotizamos");     // Your wifi username & Password
        //wifi.Join("AulasAMIGAS", "900292680");    // Your wifi username & Password
        wifi.RcvReply(rcv, 3000);                 // receive a response from ESP
        if (!strstr(rcv,"A\"")) continue;
        wait(10);                                 // waits for response from ESP
        while (1) {
            wifi.GetIP(rcv);                      // receive an IP address from the AP
            if (!strstr(rcv,"busy")) break;
        }
        if (!strstr(rcv,"AR")) break;
    }
    pc.printf("Conectado\r\n");
}

void buildSocket() {
    green = 1;
    wifi.SetSingle();
    wifi.RcvReply(rcv, 3000);
    while (1) {
        //strcpy(snd, "AT+CIPSTART=\"TCP\",\"104.196.113.161\",6666");
        strcpy(snd, "AT+CIPSTART=\"TCP\",\"10.69.17.20\",6666");
        wifi.SendCMD(snd);
        wifi.RcvReply(rcv, 3000);
        pc.printf("Conectando al servidor.... \r\n");
        if (strstr(rcv,"Linked")||strstr(rcv,"ALREAY CONNECT")) break;
    }
    pc.printf("Link creado\r\n");
}

void readCard(MFRC522 *rf, bool in) {
    green = 1;
    if (!rf->PICC_ReadCardSerial()) return;
    sprintf(UIDstr, "%02X%02X%02X%02X",
                    rf->uid.uidByte[0],
                    rf->uid.uidByte[1],
                    rf->uid.uidByte[2],
                    rf->uid.uidByte[3]);
    if (in) dir = 1;
    else dir = 2;
}

int main()
{
    green = 1;
    // Init ESP
    ESP_Enable = 0;
    ESP_Reset = 0;
    ESP_Reset = 1;
    ESP_Enable = 1;
    wifi.Reset();
    wait(5);
    wifi.SetMode(1);             // set ESP mode to 1
    wifi.RcvReply(rcv, 1000);    // receive a response from ESP
    connect();                   // Connect to wifi
    buildSocket();               // Build socket
    
    // Init RF sensors
    rf_in = new MFRC522(PB_15, PB_14, PB_13, PC_4, PA_13);
    rf_in->PCD_Init();
    rf_out = new MFRC522(PC_12, PC_11, PC_10, PD_2, PA_14);
    rf_out->PCD_Init();
    while(1) {
        green = 0;
        dir = 0;
        if (rf_in->PICC_IsNewCardPresent()) {readCard(rf_in,1);}
        else if (rf_out->PICC_IsNewCardPresent()) readCard(rf_out,0);
        if (!dir) {wait_ms(500);continue;}

        strcpy(snd, "AT+CIPSEND=12");
        wifi.SendCMD(snd);
        wifi.RcvReply(rcv, 500);
        // Socket verification
        if (strstr(rcv,"ERROR")||strstr(rcv,"link is not")) {
            buildSocket();
            continue;
        }
        if (dir==1) sprintf(snd,"%s,I",UIDstr);
        else sprintf(snd,"%s,O",UIDstr);
        pc.printf("REQ: %s\r\n", snd);
        wifi.SendCMD(snd);
        wifi.RcvReply(rcv, 10000);
        pc.printf("%s\r\n", rcv);
        
        spr = strchr(rcv,'+');
        if (spr!=NULL) {
            if (spr[1]=='I'&&spr[3]=='D') {
                spr = strchr(rcv,':');
                if (spr[1]=='1') {
                    green = 1;
                    pc.printf("Acceso Concedido\r\n");
                } else {
                    pc.printf("Acceso Denegado\r\n");
                }
            }
        } else pc.printf("No respuesta\r\n");
        wait_ms(1000);
    }
}
