#include "mbed.h"
#include <LCDConsole.h>
#include <stdio.h>
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "EquatorialMount.h"
#include "MCULoadMeasurement.h"
#include "telescope_hardware.h"

Thread blinker_thread(osPriorityNormal, 1024, NULL, "Blinker");
DigitalOut led1(LED1);

void blink()
{
	while (true)
	{
		led1 = !led1;
		Thread::wait(80);
	}
}

//Thread printer_th(osPriorityNormal, 2048, NULL, "Printer Thread");
///* Mail */
//typedef struct
//{
//	char msg[128];
//} mail_t;
//
//typedef Mail<mail_t, 256> MB_t;
//MB_t mbox;
//Serial pc(USBTX, USBRX, 115200);
//
//Timer tim;
//void printer(MB_t *mbox)
//{
//	while (true)
//	{
//		mail_t *m = (mail_t *) mbox->get().value.p;
//		pc.printf("%s\r\n", m->msg);
//		mbox->free(m);
//	}
//}

/**
 * Printf for debugging use. Takes about 20us for each call. Can be called from any context
 */
//void xprintf(const char* format, ...)
//{
//	uint16_t len;
//	va_list argptr;
//	va_start(argptr, format);
//
//	mail_t *m = mbox.alloc();
//	len = sprintf(m->msg, "%9d>", tim.read_us());
//	len += vsprintf(&m->msg[len], format, argptr);
//	mbox.put(m);
//
//	va_end(argptr);
//}

int main()
{
	/*Enable LCD redirecting*/
	LCDConsole::init(0, 0, 240, 280);
	LCDConsole::redirect(true);
	setvbuf(stdout, NULL, _IONBF, 0);
	setvbuf(stderr, NULL, _IONBF, 0);

	printf("System initialized.\n");

	blinker_thread.start(blink);
	telescopeHardwareInit();
	telescopeServerInit();

	while (1)
	{
		Thread::wait(1000);
	}
}


