/*
 * RTCClockHR.h
 *
 *  Created on: Sep 23, 2018
 *      Author: caoyu
 */

#ifndef RTCCLOCKHR_H_
#define RTCCLOCKHR_H_

#include "mbed.h"
#include "RTCClock.h"
#include "mbed_mktime.h"
#include "rtc_api_hal.h"

class RTCClockHR: public RTCClock {
public:
	RTCClockHR(){
	}
	virtual ~RTCClockHR(){
	}

	virtual double getTimeHighResolution() {
		struct tm timeinfo;

		/* Since the shadow registers are bypassed we have to read the time twice and compare them until both times are the same */
		uint32_t Read_time = RTC->TR & RTC_TR_RESERVED_MASK;
		uint32_t Read_date = RTC->DR & RTC_DR_RESERVED_MASK;
		uint32_t Read_ss = RTC->SSR & (0xFFFF);

		while ((Read_ss != (RTC->SSR & 0xFFFF))
				|| (Read_time != (RTC->TR & RTC_TR_RESERVED_MASK))
				|| (Read_date != (RTC->DR & RTC_DR_RESERVED_MASK))) {
			Read_ss = RTC->SSR & 0xFFFF;
			Read_time = RTC->TR & RTC_TR_RESERVED_MASK;
			Read_date = RTC->DR & RTC_DR_RESERVED_MASK;
		}

		/* Setup a tm structure based on the RTC
		 struct tm :
		 tm_sec      seconds after the minute 0-61
		 tm_min      minutes after the hour 0-59
		 tm_hour     hours since midnight 0-23
		 tm_mday     day of the month 1-31
		 tm_mon      months since January 0-11
		 tm_year     years since 1900
		 tm_yday     information is ignored by _rtc_maketime
		 tm_wday     information is ignored by _rtc_maketime
		 tm_isdst    information is ignored by _rtc_maketime
		 */
		timeinfo.tm_mday = RTC_Bcd2ToByte(
				(uint8_t) (Read_date & (RTC_DR_DT | RTC_DR_DU)));
		timeinfo.tm_mon = RTC_Bcd2ToByte(
				(uint8_t) ((Read_date & (RTC_DR_MT | RTC_DR_MU)) >> 8)) - 1;
		timeinfo.tm_year = RTC_Bcd2ToByte(
				(uint8_t) ((Read_date & (RTC_DR_YT | RTC_DR_YU)) >> 16)) + 68;
		timeinfo.tm_hour = RTC_Bcd2ToByte(
				(uint8_t) ((Read_time & (RTC_TR_HT | RTC_TR_HU)) >> 16));
		timeinfo.tm_min = RTC_Bcd2ToByte(
				(uint8_t) ((Read_time & (RTC_TR_MNT | RTC_TR_MNU)) >> 8));
		timeinfo.tm_sec = RTC_Bcd2ToByte(
				(uint8_t) ((Read_time & (RTC_TR_ST | RTC_TR_SU)) >> 0));

		// Convert to timestamp
		time_t t;
		if (_rtc_maketime(&timeinfo, &t, RTC_4_YEAR_LEAP_YEAR_SUPPORT) == false) {
			return 0;
		}

		// Add fractional part
		double thr = (double) t
				+ (double) (PREDIV_S_VALUE - Read_ss) / (PREDIV_S_VALUE + 1);

		return thr;
	}
};

#endif /* RTCCLOCKHR_H_ */
