/*********************************************************************
This is a library for our Monochrome OLEDs based on SSD1306 drivers

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/category/63_98

These displays use SPI to communicate, 4 or 5 pins are required to  
interface

Adafruit invests time and resources providing this open source code, 
please support Adafruit and open-source hardware by purchasing 
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.  
BSD license, check license.txt for more information
All text above, and the splash screen below must be included in any redistribution
*********************************************************************/

/*
 *  Modified by Neal Horman 7/14/2012 for use in LPC1768
 */

#include "mbed.h"
#include "Adafruit_SSD1306.h"

uint8_t splashScreen[SSD1306_LCDHEIGHT * SSD1306_LCDWIDTH / 8] = {
0x00, 0xFE, 0x02, 0xDA, 0xDA, 0xC2, 0xFE, 0x02, 0xDE, 0xDE, 0x02, 0xFE, 0xFA, 0xFA, 0x02, 0xFA,
0xFA, 0xFE, 0x02, 0xDA, 0xDA, 0xFA, 0xFE, 0xE2, 0x1E, 0xFE, 0x1E, 0xE2, 0xFE, 0x02, 0xDA, 0xDA,
0xFA, 0xFE, 0x02, 0xE6, 0xDE, 0x3E, 0x02, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x1F, 0x1F, 0x5F, 0x1F, 0x0F, 0x8F,
0x0F, 0x0F, 0x4F, 0x8F, 0x5F, 0x9F, 0x5F, 0x9F, 0x0F, 0x8F, 0x4F, 0x87, 0x47, 0x27, 0x47, 0x87,
0x07, 0x07, 0x47, 0x0F, 0x4F, 0x0F, 0x0F, 0x9F, 0x1F, 0x3F, 0x3F, 0x3F, 0x7F, 0x7F, 0x7F, 0x1F,
0x1F, 0x8F, 0x4F, 0xAF, 0x47, 0x27, 0x17, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x05, 0x89,
0x01, 0x01, 0x03, 0x03, 0x53, 0x27, 0x47, 0x8F, 0x1F, 0x9F, 0x3F, 0xBF, 0x3F, 0x7F, 0xFF, 0xFF,
0xF8, 0xFB, 0xFA, 0xFB, 0xFB, 0xFB, 0xFB, 0xFA, 0xFB, 0xFB, 0xFA, 0xFB, 0xFB, 0xFB, 0xFA, 0xFB,
0xFB, 0xFB, 0xFA, 0xFA, 0xFA, 0xFA, 0xFB, 0xFB, 0xFB, 0xFA, 0xFB, 0xFB, 0xFB, 0xFA, 0xFA, 0xFA,
0xFA, 0xFB, 0xFA, 0xFB, 0xFB, 0xFB, 0xFA, 0xFB, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F,
0x3F, 0x3F, 0x0F, 0x8F, 0x43, 0x21, 0x10, 0x08, 0x08, 0x00, 0x40, 0x20, 0x00, 0x20, 0x00, 0x82,
0x80, 0x80, 0xE1, 0x61, 0x40, 0x60, 0x50, 0x72, 0x30, 0x20, 0xC0, 0x80, 0x00, 0x80, 0x14, 0x82,
0x08, 0x00, 0x00, 0x00, 0x58, 0x8C, 0x16, 0x2A, 0x88, 0xC4, 0x68, 0xB0, 0x58, 0xAD, 0x56, 0xAA,
0x80, 0xC0, 0x40, 0xA0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x04, 0xC6, 0x82, 0x02, 0x82, 0x04,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x28, 0x00, 0x80, 0x00, 0x00, 0x10, 0x20, 0x54, 0x00,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x0F, 0x07, 0x03, 0x83, 0x41, 0x28, 0x14, 0x0A,
0x80, 0x80, 0x41, 0x41, 0x51, 0x1A, 0x1E, 0x58, 0x0E, 0x06, 0x02, 0x80, 0x42, 0x28, 0x14, 0x82,
0x40, 0x30, 0x18, 0x0C, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x0C, 0x08, 0x30, 0xF0, 0x60, 0x41,
0x08, 0x80, 0x62, 0xB0, 0x58, 0xA8, 0x50, 0xA2, 0x80, 0xC0, 0x62, 0xB1, 0x5A, 0xAD, 0x56, 0xAB,
0xA8, 0xD4, 0x60, 0xB0, 0x50, 0xA8, 0x50, 0x88, 0x03, 0x02, 0xE6, 0xFC, 0x26, 0x03, 0x03, 0x80,
0x00, 0x00, 0x00, 0x80, 0xE0, 0x38, 0x40, 0xA8, 0x80, 0x80, 0x40, 0x20, 0x10, 0xC2, 0xFE, 0xFC,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x7F, 0x3F, 0x3F, 0x3F, 0xBF, 0x3F, 0x3F, 0x3F, 0x9F,
0x1F, 0x9F, 0x1F, 0x9F, 0x0F, 0x2F, 0x4F, 0xAF, 0x87, 0xC7, 0x67, 0xB7, 0x57, 0xA7, 0x57, 0xA7,
0x87, 0xE7, 0xC3, 0x83, 0x51, 0xA9, 0x54, 0xA8, 0x00, 0xE0, 0x40, 0x80, 0xC0, 0xA0, 0xD2, 0xA3,
0x41, 0xC1, 0xE0, 0xA0, 0x50, 0xA8, 0x54, 0xAE, 0x1C, 0x97, 0x7C, 0xE8, 0x60, 0xC0, 0x80, 0xC0,
0x80, 0x82, 0x00, 0x00, 0x10, 0x20, 0x00, 0x08, 0x00, 0x00, 0x14, 0x82, 0x41, 0x21, 0x10, 0xA8,
0x00, 0x80, 0x42, 0xB1, 0x50, 0xA8, 0x54, 0xAA, 0x88, 0xC0, 0x62, 0xB1, 0x58, 0xAD, 0x56, 0xAB,
0xA8, 0xD4, 0x62, 0xB1, 0x58, 0xAC, 0x56, 0xAA, 0x80, 0x00, 0x60, 0xA0, 0x40, 0x80, 0x00, 0x80,
0x80, 0x48, 0x2E, 0x93, 0xC8, 0xE4, 0xF4, 0xF2, 0xF8, 0xFC, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xC0, 0x90, 0x08, 0x3F, 0x65, 0x41, 0x81, 0x03, 0x80, 0x02, 0x1E,
0x3C, 0x80, 0x00, 0x80, 0x58, 0x88, 0x44, 0xAA, 0xA0, 0xC0, 0x60, 0xB3, 0x56, 0xAC, 0x11, 0x8B,
0x06, 0x84, 0x5D, 0xAF, 0x5D, 0x29, 0xD7, 0x0A, 0xA2, 0x62, 0x62, 0x33, 0x5F, 0xAA, 0x14, 0x8D,
0x89, 0x42, 0x68, 0x19, 0x5B, 0x3A, 0x74, 0x23, 0x82, 0xF6, 0x6C, 0x3B, 0x7A, 0xAA, 0x56, 0xAE,
0x8B, 0xC2, 0x66, 0xA8, 0x58, 0xB8, 0x50, 0xA8, 0x80, 0xC0, 0x60, 0xB0, 0x58, 0xA8, 0x54, 0xAA,
0xA8, 0xD0, 0x42, 0x90, 0x58, 0x0C, 0x16, 0x29, 0x00, 0x04, 0x02, 0x31, 0x5A, 0xAD, 0x56, 0xAB,
0xA8, 0xD4, 0x62, 0x35, 0x9A, 0xC1, 0x46, 0x03, 0x22, 0x54, 0x60, 0x01, 0x42, 0x8D, 0x76, 0xFB,
0x80, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0xF8, 0xF8, 0xF0, 0xF0, 0xF1, 0xF1, 0xE1,
0xE0, 0xE1, 0xE0, 0xC1, 0xC0, 0xC2, 0xD2, 0x10, 0x72, 0x72, 0x11, 0x02, 0x81, 0x30, 0x72, 0xF1,
0x12, 0x12, 0x02, 0x00, 0x03, 0x12, 0x30, 0xF3, 0x00, 0x03, 0x20, 0xE1, 0x62, 0x00, 0x02, 0x02,
0x00, 0x33, 0x70, 0x72, 0x32, 0x02, 0x01, 0x03, 0x01, 0x02, 0x80, 0xE3, 0xC1, 0xC7, 0x87, 0x07,
0x0A, 0x1D, 0x1A, 0x15, 0x3A, 0x2C, 0x56, 0xBB, 0xAA, 0xD5, 0x6A, 0xB5, 0xDA, 0xED, 0x76, 0xBB,
0xAA, 0xD5, 0x7A, 0x34, 0x5A, 0x94, 0x16, 0x9B, 0x88, 0xC0, 0x6B, 0xB0, 0x5C, 0xAC, 0x50, 0xA1,
0x08, 0x00, 0x2A, 0xB5, 0x1A, 0x8D, 0x44, 0x01, 0xA0, 0x04, 0x6A, 0x34, 0x00, 0x05, 0x06, 0xBB,
0xAA, 0xD4, 0x41, 0x87, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE,
0xFE, 0xFC, 0xFC, 0xF0, 0xE0, 0xC0, 0x90, 0x88, 0x00, 0x00, 0x00, 0x00, 0x50, 0x2C, 0x14, 0xA8,
0x00, 0x18, 0x30, 0xC0, 0x40, 0x20, 0x14, 0xAA, 0x08, 0x04, 0x60, 0xA3, 0x53, 0x20, 0x40, 0xA0,
0x00, 0x00, 0x40, 0xA0, 0x50, 0x80, 0x10, 0xA0, 0x80, 0x85, 0x62, 0x85, 0x02, 0xA5, 0x06, 0x83,
0x82, 0x05, 0x08, 0x84, 0x4A, 0xCD, 0x46, 0xE3, 0xA8, 0xA4, 0x0A, 0x95, 0x1A, 0x8D, 0x06, 0x23,
0x88, 0x04, 0x02, 0x81, 0xC2, 0x61, 0x56, 0x2B, 0x0A, 0x00, 0x80, 0xB0, 0x18, 0x00, 0xE0, 0xBB,
0xAA, 0xD5, 0x40, 0x00, 0x00, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
0xFE, 0xFE, 0xFC, 0xF8, 0xF8, 0xF8, 0xF8, 0xF0, 0xF0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xC4, 0xCA,
0xC0, 0xC0, 0xC2, 0xD1, 0xD8, 0x8C, 0x96, 0xAB, 0x88, 0x04, 0x0A, 0xA5, 0x5A, 0xAC, 0x56, 0x2B,
0x0A, 0x05, 0x02, 0x81, 0x42, 0xA1, 0x70, 0x7A, 0x2A, 0x14, 0x02, 0x89, 0x00, 0x20, 0x16, 0x8B,
0x08, 0x80, 0x00, 0x80, 0xC0, 0xE0, 0x70, 0xB0, 0xA8, 0xD7, 0xEA, 0xF5, 0xF8, 0xFC, 0xF6, 0xFB,
0xAA, 0xD5, 0x40, 0x00, 0x00, 0xE0, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

Adafruit_SSD1306::Adafruit_SSD1306(SPI &spi, PinName DC, PinName RST, PinName CS)
    : Adafruit_GFX(SSD1306_LCDWIDTH, SSD1306_LCDHEIGHT)
    , rst(RST,false), cs(CS,true), dc(DC,false), mspi(spi)
{
    memcpy(buffer,splashScreen,sizeof(buffer));
    begin();
    display();
};

void Adafruit_SSD1306::begin(uint8_t vccstate)
{
    rst = 1;
    // VDD (3.3V) goes high at start, lets just chill for a ms
    wait_ms(1);
    // bring reset low
    rst = 0;
    // wait 10ms
    wait_ms(10);
    // bring out of reset
    rst = 1;
    // turn on VCC (9V?)
    
/*#if defined SSD1306_128_32
    // Init sequence for 128x32 OLED module
    ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE
    ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5
    ssd1306_command(0x80);                                  // the suggested ratio 0x80
    ssd1306_command(SSD1306_SETMULTIPLEX);                  // 0xA8
    ssd1306_command(0x1F);
    ssd1306_command(SSD1306_SETDISPLAYOFFSET);              // 0xD3
    ssd1306_command(0x0);                                   // no offset
    ssd1306_command(SSD1306_SETSTARTLINE | 0x0);            // line #0
    ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D
    if (vccstate == SSD1306_EXTERNALVCC) 
    { ssd1306_command(0x10); }
    else 
    { ssd1306_command(0x14); }
    ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20
    ssd1306_command(0x00);                                  // 0x0 act like ks0108
    ssd1306_command(SSD1306_SEGREMAP | 0x1);
    ssd1306_command(SSD1306_COMSCANDEC);
    ssd1306_command(SSD1306_SETCOMPINS);                    // 0xDA
    ssd1306_command(0x02);
    ssd1306_command(SSD1306_SETCONTRAST);                   // 0x81
    ssd1306_command(0x8F);
    ssd1306_command(SSD1306_SETPRECHARGE);                  // 0xd9
    if (vccstate == SSD1306_EXTERNALVCC) 
    { ssd1306_command(0x22); }
    else 
    { ssd1306_command(0xF1); }
    ssd1306_command(SSD1306_SETVCOMDETECT);                 // 0xDB
    ssd1306_command(0x40);
    ssd1306_command(SSD1306_DISPLAYALLON_RESUME);           // 0xA4
    ssd1306_command(SSD1306_NORMALDISPLAY);                 // 0xA6
#endif*/
    
#if defined SSD1306_128_64
    // Init sequence for 128x64 OLED module
    ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE
    ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5
    ssd1306_command(0x80);                                  // the suggested ratio 0x80
    ssd1306_command(SSD1306_SETMULTIPLEX);                  // 0xA8
    ssd1306_command(0x3F);
    ssd1306_command(SSD1306_SETDISPLAYOFFSET);              // 0xD3
    ssd1306_command(0x0);                                   // no offset
    ssd1306_command(SSD1306_SETSTARTLINE | 0x0);            // line #0
    ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D
    if (vccstate == SSD1306_EXTERNALVCC) 
    { ssd1306_command(0x10); }
    else 
    { ssd1306_command(0x14); }
    ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20
    ssd1306_command(0x00);                                  // 0x0 act like ks0108
    ssd1306_command(SSD1306_SEGREMAP | 0x1);
    ssd1306_command(SSD1306_COMSCANDEC);
    ssd1306_command(SSD1306_SETCOMPINS);                    // 0xDA
    ssd1306_command(0x12);
    ssd1306_command(SSD1306_SETCONTRAST);                   // 0x81
    if (vccstate == SSD1306_EXTERNALVCC) 
    { ssd1306_command(0x9F); }
    else 
    { ssd1306_command(0xCF); }
    ssd1306_command(SSD1306_SETPRECHARGE);                  // 0xd9
    if (vccstate == SSD1306_EXTERNALVCC) 
    { ssd1306_command(0x22); }
    else 
    { ssd1306_command(0xF1); }
    ssd1306_command(SSD1306_SETVCOMDETECT);                 // 0xDB
    ssd1306_command(0x40);
    ssd1306_command(SSD1306_DISPLAYALLON_RESUME);           // 0xA4
    ssd1306_command(SSD1306_NORMALDISPLAY);                 // 0xA6
#endif
    
    ssd1306_command(SSD1306_DISPLAYON);//--turn on oled panel
}

// the most basic function, set a single pixel
void Adafruit_SSD1306::drawPixel(int16_t x, int16_t y, uint16_t color)
{
    if ((x < 0) || (x >= width()) || (y < 0) || (y >= height()))
        return;
    
    // check rotation, move pixel around if necessary
    switch (getRotation())
    {
        case 1:
            swap(x, y);
            x = _rawWidth - x - 1;
            break;
        case 2:
            x = _rawWidth - x - 1;
            y = _rawHeight - y - 1;
            break;
        case 3:
            swap(x, y);
            y = _rawHeight - y - 1;
            break;
    }  
    
    // x is which column
    if (color == WHITE) 
        buffer[x+ (y/8)*SSD1306_LCDWIDTH] |= _BV((y%8));  
    else
        buffer[x+ (y/8)*SSD1306_LCDWIDTH] &= ~_BV((y%8)); 
}

void Adafruit_SSD1306::invertDisplay(bool i)
{
    if (i)
        ssd1306_command(SSD1306_INVERTDISPLAY);
    else
        ssd1306_command(SSD1306_NORMALDISPLAY);
}

//function inverts display of num characters starting at row x, column y
void Adafruit_SSD1306::invertSection(int16_t x, int16_t y, int16_t num)
{
    if (x+num > 21 || y>8)
        return;
    else {
    int k;
    for (k=0;k<(num*6);k++)
    buffer[x*6+y*SSD1306_LCDWIDTH+k]=~buffer[x*6+y*SSD1306_LCDWIDTH+k];
    }
}

void Adafruit_SSD1306::ssd1306_command(uint8_t c)
{
    cs = 1;
    dc = 0;
    cs = 0;
    mspi.write(c);
    cs = 1;
}

void Adafruit_SSD1306::ssd1306_data(uint8_t c)
{
    cs = 1;
    dc = 1;
    cs = 0;
    mspi.write(c);
    cs = 1;
}

void Adafruit_SSD1306::display(void)
{
    ssd1306_command(SSD1306_SETLOWCOLUMN | 0x0);  // low col = 0
    ssd1306_command(SSD1306_SETHIGHCOLUMN | 0x0);  // hi col = 0
    ssd1306_command(SSD1306_SETSTARTLINE | 0x0); // line #0

    cs = 1;
    dc = 1;
    cs = 0;
    
    for (uint16_t i=0; i<(SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT/8); i++)
        mspi.write(buffer[i]);

    // i wonder why we have to do this (check datasheet)
    if (SSD1306_LCDHEIGHT == 32)
    {
        for (uint16_t i=0; i<(SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT/8); i++)
            mspi.write(0);
    }
    
    cs = 1;
}

// clear everything
void Adafruit_SSD1306::clearDisplay(void)
{
    memset(buffer,0,sizeof(buffer));
}
