#include "mbed.h"
#include "ChainableLED.h"
#include "M2XStreamClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"

DigitalOut myled(LED1);
// ChainableLED(clk, data, number_of_leds)
ChainableLED color_led(D4, D5, 1);
#include "DHT.h"

DHT sensor(D3, DHT11);
DigitalOut relay(D6);

/*
*  ESP8266 Wifi Config for nucleo 411
*/
ESP8266Interface wifi(D8,D2,D3,"SouthHackUp","",115200); // TX,RX,Reset,SSID,Password,Baud 

//
// Fill these field in from you ATT M2X Account
//
char deviceId[] = "<deviceID>"; // Device you want to push to
char streamName[] = "<streamID>"; // Stream you want to push to
char m2xKey[] = "<deviceAPIKey>"; // Your M2X API Key or Master API Key


int main() {
// dht related
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
     
    
    printf("Starting...\r\n");

    // connect to wifi
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    printf("IP Address is %s \n\r", wifi.getIPAddress());    
    
    while(1) {
        // generate random RGB values for LED's
        uint8_t R = rand();
        uint8_t G = rand();
        uint8_t B = rand();
        // print message to terminal
        //printf("R=%x,G=%x,B=%x,",R,G,B);

        // ChainableLED.setColorRGB(index_of_led, red, green, blue)
        color_led.setColorRGB(0, R, G, B);     
        myled = 1; // LED is ON
        relay = 1;
        
        wait(1.0); // 200 ms
        
        
        myled = 0; // LED is OFF
        relay = 0;
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\r\n", k, c, f);
            printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\r\n", h, dp, dpf);
        } else {
            printf("Error: %d\n", error);
        }
        wait(1.0); // 1 sec
    }
}
