#include "mbed.h"
#include "rtos.h"
 
#define SIG_RX_CAN  0x01
 
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);

 
Thread threadA;
Thread threadB;
 
 
CAN CanPort(p30, p29);
CANMessage  MessageRx; 
CANMessage  MessageTx;

PwmOut Speaker(p21);
 
unsigned int    Id;
 
void canReader(void)
{ 
    if (CanPort.read(MessageRx))
    {
        led1 = !led1;
            threadA.signal_set(SIG_RX_CAN);
    }  
} 
 
 
 // THREAD DE RECEPTION
void thA() 
{
    while(true)
    {
        // le thread attend un signe du canReader()
        Thread::signal_wait(SIG_RX_CAN);    
        led2 = !led2;

        // si l'ID correspond à notre protocole applicatif ( 0X111 pour le speaker)
        // alors on traite la trame, sinon on ne fait rien
        if (MessageRx.id == 0x111){

            // la lecture du badge est autorisée (data reçue : 0x01)
            if (MessageRx.data[0] == 0x01){
                led1 = !led1;
                // on fait 2 bips
                Speaker.write(0.3);    
                wait(0.1);
                Speaker.write(0.3);    
                wait(0.1);

            }
            else if (MessageRx.data[0] == 0x00){
                // dans ce cas là, l'accès est refusée (data reçue : 0x00)
                led1 =  !led1;
                // on fait 6 petits bips 
                for (int i = 0; i<6 ; i++){
                    Speaker.write(0.1);    
                    wait(0.1);
                }
            }
        }
            
    }
}
 
// THREAD D'ENVOI
/*void thB() 
{
    while (true) 
    {
    led1 = !led1;   
    printf("TIC3s\n");
    MessageTx.id=Id;
    CanPort.write(MessageTx);
    
    if (Id < 0x3FF) Id++;
    else Id = 0x000;
    
    wait(3);   
    }
}
 */
 
 
int main() 
{
    CanPort.frequency(20000);
    
    CanPort.attach(canReader,CAN::RxIrq);
        
    threadA.start(thA);
    
    led1 = 0;
    printf("Start OK\n");
    
    while (true) 
        {
    
        }
}
 
