
#include "mbed.h"
#define u16_max 65526
AnalogIn mic(PB_0);
DigitalOut vcc(GPIO0);
Serial pc(UART_TX, UART_RX, 115200);
const int sampleTime = 50;
int micOut;
// Find the Peak-to-Peak Amplitude Function
int findPTPAmp(float* sampleArr){
// Time variables to find the peak-to-peak amplitude
   
   unsigned int PTPAmp = 0; 

// Signal variables to find the peak-to-peak amplitude
   unsigned int maxAmp = 0;
   unsigned int minAmp = 1023;

// Find the max and min of the mic output within the 50 ms timeframe
    for(int i=0; i<8000; i++)
   {
      if( sampleArr[i] < 1023) //prevent erroneous readings
      {
        if (sampleArr[i] > maxAmp)
        {
          maxAmp = sampleArr[i]; //save only the max reading
        }
        else if (sampleArr[i] < minAmp)
        {
          minAmp = sampleArr[i]; //save only the min reading
        }
      }
   }

  PTPAmp = maxAmp - minAmp; // (max amp) - (min amp) = peak-to-peak amplitude
  double micOut_Volts = (PTPAmp * 3.3) / 1024; // Convert ADC into voltage

  //Uncomment this line for help debugging (be sure to also comment out the VUMeter function)
  //Serial.println(PTPAmp); 

  //Return the PTP amplitude to use in the soundLevel function. 
  // You can also return the micOut_Volts if you prefer to use the voltage level.
  return PTPAmp;   
}

void record(float* sampleArr) {
    float val;
    //record sound for 1 second
    for(int i=0; i<800; i++) {
        val = mic.read();
        sampleArr[i] = val; //put samples in array
        pc.printf("%f\n",val);
        wait(0.000125f); //sample rate of 8000 Hz
    }  
}

int main(){
    //float sampleArr[800]; //used to store sound 
    pc.printf("\r\n Sparkfun MEM Microphone Test\n");   
    pc.printf("******************\n");
    vcc = 1;
    int val;
    int ptpAmp;
    while(1){
        //wait(0.2); 
        //record(sampleArr); 
        val = (int)mic.read_u16();
        pc.printf("%d\n",val-32768);
        //ptpAmp=findPTPAmp(sampleArr);
    }
}

     
     
