/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "stats_report.h"
#include <AnalogIn.h>
#include <AnalogOut.h>

#include "stm32l1xx_hal.h"
#include "stm32l1xx_hal_def.h"
#include "stm32l1xx_hal_adc_ex.h"

AnalogOut v_src(GPIO0);
AnalogIn therm(GPIO2);

#define SLEEP_TIME                  50 // (msec)
#define PRINT_AFTER_N_LOOPS         20


static void SystemClock_Config(void)
{
    
}

void ConfigureADC()
{
    


}

// main() runs in its own thread in the OS
int main()
{
    SystemInit();
    /* Setup GPIO for LEDs                                                      */
    RCC->APB2ENR |=  1 <<  6;             /* Enable GPIOE clock                 */
    
    /* Setup and initialize ADC converter                                       */
    RCC->APB2ENR |=  1 <<  9;             /* Enable ADC1 clock                  */
    //GPIOC->CRL   &= 0xFFF0FFFF;           /* Configure PC4 as ADC.14 input      */
    ADC1->SQR1    = 0x00000000;           /* Regular channel 1 conversion       */
    ADC1->SQR2    = 0x00000000;           /* Clear register                     */
    ADC1->SQR3    = 14 <<  0;             /* SQ1 = channel 14                   */
    ADC1->SMPR1   =  5 << 12;             /* Channel 14 sample time is 55.5 cyc */
    ADC1->SMPR2   = 0x00000000;           /* Clear register                     */
    ADC1->CR1     =  1 <<  8;             /* Scan mode on                       */
    ADC1->CR2     = (1 << 20) |           /* Enable external trigger            */
                  (7 << 17) |           /* EXTSEL = SWSTART                   */
                  (1 <<  1) |           /* Continuous conversion              */
                  (1 <<  0) ;           /* ADC enable                         */
    ADC1->CR2    |=  1 <<  3;             /* Initialize calibration registers   */
    while (ADC1->CR2 & (1 << 3));         /* Wait for initialization to finish  */
    ADC1->CR2    |=  1 <<  2;             /* Start calibration                  */
    while (ADC1->CR2 & (1 << 2));         /* Wait for calibration to finish     */
    ADC1->CR2    |=  1 << 22;             /* Start first conversion             */ 
    int AD_val;
    
    // this part instead of API analog_read 
    for (;;) {                            /* Loop forever                       */
        if (ADC1->SR & (1 << 1)) {          /* If conversion has finished         */
          AD_val = ADC1->DR & 0x0FFF;       /* Read AD converted value            */
          ADC1->CR2 |= 1 << 22;             /* Start new conversion               */ 
        }
    }
}
