#include "mbed.h"
#include "Wifly.h"

//wifly instance is created with no security, without ssid and password
Wifly wifly(PTD3, PTD2, PTC8, PTC7, NULL, NULL, NONE);

Serial pc(USBTX,USBRX);

//motor control pins
DigitalOut dirRight(PTC9);
DigitalOut dirLeft(PTA13);
PwmOut pwmRight(PTD5);
PwmOut pwmLeft(PTD0);

//LED control pin. LED is located on Zumo Shield
DigitalOut led(PTD1);

//append function appends a char to
void append(char* s, char c);

//send function sends the given char* to wifly
void sendString(char* str);

int main() {
    //factory reset Wifly
    wifly.reset();
    pc.printf("\nFactory Reset\n");
    //reboot wifly
    bool success = wifly.reboot();
    pc.printf("Reboot: %d\n", success); //success = 1 -> successful process
    //set TCP Listen port that will be used to 2000. You can set this to your preferred port number.
    success = wifly.sendCommand("set ip local 2000\r", "AOK");
    pc.printf("Local = 2000: %d\n", success); //success = 1 -> successful process
    //make WiFly Module work as an Access Point
    success = wifly.sendCommand("apmode\r", "AP mode");
    pc.printf("AP Mode: %d\n", success); //success = 1 -> successful process
    
    char str[15] = "";
    int count = 0; //count will be used to count characters after finding 'L' for "Listen"
    bool foundL = false; //will be made true when wifly sends 'L' character to mbed from its serial port
    bool foundO = false; //will be made true when wifly sends 'O' character to mbed from its serial port
    
    /*
    After this state, the code will monitor input characters from WiFly and executes some code
    after finding "Listen" or "OPEN" keywords
    */
    
    while(true) {
        //get current character from wifly's serial port
        char ch = wifly.getc();
        
        //----Find "Listen" to find the port number----
        if(!foundL) {
            if(ch == 'L') {
                foundL = true;
                append(str, ch);
                continue;
            }
        }
        else {
            if(count <= 4) {
                append(str, ch);
                count++;
                continue;
            }
            else {
                if(!strcmp(str, "Listen")) {
                    char portString[5] = "";
                    for(int i = 0; i < 7; i++) {
                        char portChar = wifly.getc();
                        if(i >= 3) {
                            append(portString, portChar);
                        }
                    }
                    //print the port number that WiFly Module listens
                    pc.printf("\nPort: %s", portString);
                }
                foundL = false;
                count = 0;
                str[0] = 0; //clear char* array
                continue;
            }
        }
        //----End of Find "Listen" to find the port number----
        
        //----Find "OPEN" to find out if a TCP Connection is established----
        if(!foundO) {
            if(ch == 'O') {
                foundO = true;
                append(str, ch);
                continue;
            }
        }
        else {
            if(count <= 2) {
                append(str, ch);
                count++;
                continue;
            }
            else {
                if(!strcmp(str, "OPEN")) { //"OPEN" is found, start the demo program
                    pc.printf("\nConnection Established!");
                    //commandChar will be used to store current character came from TCP
                    char commandChar = 0;
                    //when "CLOS" is received, connectionEnded will be made true and the while loop
                    //contains demo program will be ended
                    bool connectionEnded = false;
                    const int period = 60;
                    pwmRight.period_us(period);
                    pwmLeft.period_us(period);
                    int speed = 20;
                    do {
                        //get current character from TCP (using wifly)
                        commandChar = wifly.getc();
                        //When 'C' is received, this could be "CLOS" message,
                        //check this in else
                        if(commandChar != 'C') {
                            
                            //You can send messages to the connected device with:
                            //wifly.putc(<char>);
                            //sendString(<char*>);
                            if(commandChar == '0') { //stop
                                pwmRight.pulsewidth_us(0);
                                pwmLeft.pulsewidth_us(0);
                            }
                            else if(commandChar == '1') { //forward
                                dirRight = 0;
                                dirLeft = 0;
                                pwmRight.pulsewidth_us(speed);
                                pwmLeft.pulsewidth_us(speed);
                            }
                            else if(commandChar == '2') { //backward
                                dirRight = 1;
                                dirLeft = 1;
                                pwmRight.pulsewidth_us(speed);
                                pwmLeft.pulsewidth_us(speed);
                            }
                            else if(commandChar == '3') { //right
                                dirRight = 1;
                                dirLeft = 0;
                                pwmRight.pulsewidth_us(speed);
                                pwmLeft.pulsewidth_us(speed);
                            }
                            else if(commandChar == '4') { //left
                                dirRight = 0;
                                dirLeft = 1;
                                pwmRight.pulsewidth_us(speed);
                                pwmLeft.pulsewidth_us(speed);
                            }
                            else if(commandChar == '5') { //forward right
                                dirRight = 0;
                                dirLeft = 0;
                                pwmRight.pulsewidth_us(speed/2);
                                pwmLeft.pulsewidth_us(speed);
                            }
                            else if(commandChar == '6') { //forward left
                                dirRight = 0;
                                dirLeft = 0;
                                pwmRight.pulsewidth_us(speed);
                                pwmLeft.pulsewidth_us(speed/2);
                            }
                            else if(commandChar == '7') { //backward right
                                dirRight = 1;
                                dirLeft = 1;
                                pwmRight.pulsewidth_us(speed/2);
                                pwmLeft.pulsewidth_us(speed);
                            }
                            else if(commandChar == '8') { //backward left
                                dirRight = 1;
                                dirLeft = 1;
                                pwmRight.pulsewidth_us(speed);
                                pwmLeft.pulsewidth_us(speed/2);
                            }
                            else if(commandChar == '9') { //speed0
                                speed = 0;
                            }
                            else if(commandChar == 'a') { //speed1
                                speed = 20;
                            }
                            else if(commandChar == 'b') { //speed2
                                speed = 40;
                            }
                            else if(commandChar == 'c') { //speed3
                                speed = 60;
                            }
                        }
                        else {
                            //construct 4 letter word from wifly serial connection and check if it is "CLOS" or not.
                            char closString[5] = "";
                            append(closString, commandChar);
                            for(int i = 0; i <= 2; i++) {
                                char closChar = wifly.getc();
                                append(closString, closChar);
                            }
                            //
                            if(!strcmp(closString, "CLOS")) {
                                pc.printf("\nConnection Closed!");
                                connectionEnded = true;
                            }
                        }
                    } while(!connectionEnded);
                }
                foundO = false;
                count = 0;
                str[0] = 0;
                continue;
            }
        }
    }
}

void append(char* s, char c) {
    int len = strlen(s);
    s[len] = c;
    s[len+1] = '\0';
}

void sendString(char* str) {
    for(int i = 0; i < strlen(str); i++) {
        wifly.putc(str[i]);
    }
}