#include "mbed.h"
#include "MCP23017.h"
#include <string>
using namespace std;

DigitalOut FPGA1(p8);
DigitalOut FPGA2(p9);
DigitalOut FPGA3(p10);
DigitalOut FPGA4(p11);

DigitalIn sorter_Tube(p5);
DigitalIn AAA_tube(p6);
InterruptIn voltage_Checker_Tube(p7);

Ticker AAA_checker;
AnalogIn diode_bridge(p16);
Serial pc(USBTX, USBRX);


uint8_t mode;
uint8_t in_Voltage_Checker;
uint16_t AA_sorted;          //Amount of AA sorted
uint16_t AA_uncharged;          //Amount of uncharged AA
uint16_t AAA_sorted;         //Amount of AAA sorted
uint8_t servo_maintenance;
float voltage;
    
void receive() 
{
   char c = pc.getc();
    if(c == 'S')//Normal Mode
    {
        mode = 1;
    }
    else if(c == 'M')//Maintenance Mode
    {
        mode = 2;
    }
    else if(c == 'A' && mode == 2)
    {
    servo_maintenance = 1;
    }
    
    else if(c == 'B' && mode == 2)
    {
        servo_maintenance = 2;

    }
    
    else if(c == 'C' && mode == 2)
    {
       servo_maintenance = 3;

    }
    else if(c == 'D' && mode == 2)
    {
       servo_maintenance = 4;

    }
    else if(c == 'N')//Emergency Stop
    {
        while(1){;}
    }
    else if (c == 'B')//Safe Stop
    {
        mode = 0;
    }
}

void AAA_passed()
{
    if(AAA_tube == 1)
    {
        AAA_sorted++;
    }
}

void in_Checker()
{
    in_Voltage_Checker = 1;

}

float average_analog(int no_of_averages)
{
    int i = 0;
    float average = 0;
    for ( i = 0; i < no_of_averages; i++)            
        {
            average += diode_bridge.read();
           wait(0.001);    // wait 1mS between reading inputs
        }
    return average/i;
}

void update_pc()
{
    AAA_checker.detach();
    
    string serial_out;
 
 
    char voltage_buffer[4];
   sprintf(voltage_buffer, "%0.3f", voltage);
 
   char AA_sorted_buffer[2];
   sprintf(AA_sorted_buffer, "%d", AA_sorted);
    
    
   char AA_uncharged_buffer[2];
   sprintf(AA_uncharged_buffer , "%d", AA_uncharged);

   char AAA_sorted_buffer[2];
   sprintf(AAA_sorted_buffer , "%d", AAA_sorted);
   
  
   
  
   if(mode == 2)
   {
   char sorter_tube_sensor = sorter_Tube.read();
   char AAA_tube_sensor = AAA_tube.read();
   
   char sorter_tube_buffer[2];
   sprintf(sorter_tube_buffer , "%d", sorter_tube_sensor);
   
   char AAA_tube_buffer[2];
   sprintf(AAA_tube_buffer , "%d", AAA_tube_sensor);
   
   pc.putc('A');
   pc.putc(sorter_tube_buffer[0]);
   pc.putc('B');
   pc.putc(AAA_tube_buffer[0]);
   pc.putc('C');
   pc.putc(in_Voltage_Checker);
   }
   
   
   pc.putc('W');
   pc.putc(voltage_buffer[0]);
   pc.putc(voltage_buffer[1]);
   pc.putc(voltage_buffer[2]);  
   pc.putc(voltage_buffer[3]);
   
   pc.putc('X');
   pc.putc(AA_sorted_buffer[0]);
   pc.putc(AA_sorted_buffer[1]);
   pc.putc('Y');
   pc.putc(AA_uncharged_buffer[0]);
   pc.putc(AA_uncharged_buffer[1]);
   pc.putc('Z');
   pc.putc(AAA_sorted_buffer[0]);
   pc.putc(AAA_sorted_buffer[1]);
   pc.putc(';');
   pc.putc('\0');
   pc.putc('\r');
   pc.putc('\n');
   wait(0.5);
       AAA_checker.attach(&AAA_passed, 0.1);  
}


void voltage_checker()
{
        AA_sorted++;
        in_Voltage_Checker = 0;
        FPGA4 = 1;     
        wait(0.5);
        FPGA4 = 0;
        voltage = average_analog(100);

        //pc.printf("%f\n", voltage);  
        wait(1);
        if (voltage < 0.2)
        {
        AA_uncharged++;
           FPGA2 = 1;
           wait(2);
           FPGA2 = 0; 
        }
        else
        {
           FPGA3 = 1;
           wait(2);
           FPGA3 = 0;
        }
}
int main() {
   pc.attach(&receive);             //Attach PC receive interrupt
   voltage_Checker_Tube.rise(&in_Checker);
   AAA_checker.attach(&AAA_passed, 0.1); 
   while(1) {
    if(mode == 1)
    {
     if(sorter_Tube == 1)
        {
            FPGA1 = 1;
            wait(1);
            FPGA1 = 0;
            wait(3);
        
            if(in_Voltage_Checker == 1)
            {
                voltage_checker();
                update_pc();   
            }
             
        }
    }
    else if(mode == 2)
    {
        

        switch(servo_maintenance)
        {
        case 1:
           FPGA1 = 1;
            wait(1);
            FPGA1 = 0;
        break;
        
        case 2:
            FPGA2 = 1;
            wait(2);
            FPGA2 = 0;
        break;
        
        case 3:
            FPGA3 = 1;
            wait(2);
            FPGA3 = 0;
        break;
        
        case 4:
            FPGA4 = 1;
            wait(1);
            FPGA4 = 0;
            wait(0.5);
            voltage_checker();
        break;
        }
        update_pc();
        servo_maintenance = 0;
        wait(4);
    }
   }
    
}
