#include "mbed.h"
#include "math.h"
#include  "mov_servos.h"

//----->Nombrar salidas PWM de servos <-----

PwmOut myServoX(PB_3);
PwmOut myServoY(PB_10);
PwmOut myServoZ(PB_4);

uint8_t  posx_old=0;     // posición anterior del eje X
uint8_t  posy_old=0;     // posición anterior del eje Y
uint8_t  ss_time=100;     // velocidad de los moteres 
//----->Configuracion del movimiento de los servos en el cuadrante  <-----

int coord2us(float coord)
{
    if(0 <= coord <= MAXPOS)
        return int(750+coord*1900/50);// u6
    return 750;
 
}
//----->Tiempo de espera para moverse  <-----


void sstime(uint8_t x, uint8_t y)
{
    double dx=abs(x-posx_old);
    double dy=abs(y-posy_old);
    double dist= sqrt(dx*dx+dy*dy);
    wait_ms((int)(ss_time*dist));
    posx_old =x;
    posy_old=y;
    
 } 
 //----->Coordenadas en el cudrante  <-----
 
 void vertex2d(uint8_t x, uint8_t y)
 {
    myServoX.period_ms(20);
    myServoY.period_ms(20);
    myServoZ.period_ms(20);
 
     int pulseX = coord2us(x);
    int pulseY = coord2us(y);
   
  
    myServoX.pulsewidth_us(pulseX);
    myServoY.pulsewidth_us(pulseY);
   
    wait_ms(ss_time);

}
 //----->Movimiento del eje Z <-----
 
void low(){
myServoZ.pulsewidth_us(1500);
wait_ms(ss_time*2);
 
}
void up(){
myServoZ.pulsewidth_ms(1);
wait_ms(ss_time*2);
 
}
 //----->Ir a home  <-----
 
void home(){
   
     up();
    vertex2d(0 ,0);
}    

