#include "mbed.h"
#include "scolor_TCS3200.h"

Serial command(USBTX, USBRX);
PwmOut mybuzzer(D9);
//                     S0,    S1,   S2,   S3,    OUT
scolor_TCS3200 scolor(PA_8, PB_10, PB_4, PB_5, PB_3); //esta es la clase, declaración de objeto

#define INITCMD 0xFE
#define INITELE 0xFE
#define CMD  0x01
#define DO  100
#define RE  150 
#define MI  200
#define FA  250
#define SO  300 

uint8_t tono;       // variable almacena la frecuencia del buzzer
uint8_t tiempo;    // varable almacena los tiempos del buzzer leer_datos()
uint8_t cmd;

// definición de las funciones
void setup_uart();
void buzzer_on(uint8_t tono);
void leer_datos();
void leer_color();

    
    
int main() {

    setup_uart();
    
    while(1){    
        leer_datos();
        if (cmd==CMD){
            leer_color();
           }    
           }
}

void setup_uart(){
    command.baud(115200);
}


void leer_datos(){
     cmd=command.getc();     
}


void leer_color(){
        
    long     red = scolor.ReadRed();
    long     green = scolor.ReadGreen();
    long     blue = scolor.ReadBlue();
    long     clear = scolor.ReadClear();
    mybuzzer.write(0);
  
    if (red <=800) // lee el rojo------------
        {
            if (green>=1200 and green <=1500)
            {
                if (blue>=1200 and blue <=1500)
                {
            
            printf("|FE 01|\n");
            mybuzzer.period_ms(DO);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                                 
                            }
            }
        }
        
         if (red <=2700)  // lee el verde --------------------------------------
        {
            if (green>=900 and green <=1500)
            {
                if (blue>=1400 and blue <=2000)
                {
            
            printf("|FE 03|\n"); 
            mybuzzer.period_ms(RE);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);      
                          
                }
            }
        }
        
         if (red<=2400) // lee el azul------------------------------------
        {
            if (green>=800 and green <=1000)
            {
                if (blue>=600 and blue <=800)
                {
                        
            printf("|FE 02|\n");
            mybuzzer.period_ms(MI);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                        
                }
            }
        }
       if (red <=700) // lee el amarillo------------------------------------
        {
            if (green>=500 and green <=700)
            {
                if (blue>=500 and blue <=1500)
                {
                        
            printf("|FE 04|\n");
            mybuzzer.period_ms(FA);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                     
                }
            }
        }
        
        if (red <=200) // lectura errada------------------------------------
        {
            if (green <=300)
            {
                if (blue <=300)
                {
                        
            printf("|FE 00|\n");
            mybuzzer.period_ms(SO);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                     
                }
            }
        }
     
  //   printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d     \n ", red, green, blue, clear);
     }

