#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "OLED_types.h"
#include "OpenSans_Font.h"
#include "string.h"
#include "FXAS21002.h"
#include "FXOS8700.h"
#include <cmath>

#define LED_ON      0
#define LED_OFF     1

void UpdateSensorData(void);
void GetSensorData(void);
void StartHaptic(void);
void StopHaptic(void const *n);
void txTask(void);
FXOS8700 accel(PTC11, PTC10);

Serial pc(USBTX, USBRX);

DigitalOut redLed(LED1,1);
DigitalOut greenLed(LED2,1);
DigitalOut blueLed(LED3,1);
DigitalOut haptic(PTB9);

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);

/* Instantiate the SSD1351 OLED Driver */ 
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

/*Create a Thread to handle sending BLE Sensor Data */ 
Thread txThread;

 /* Text Buffer */ 
char text[20]; 

uint8_t battery = 100;
int16_t x = 0;
int16_t y = 0;
int16_t z = 0;

uint8_t abs_x = 0;
uint8_t abs_y = 0;
uint8_t abs_z = 0;
float accel_data[3];

/****************************Call Back Functions*******************************/
void ButtonRight(void)
{
    StartHaptic();
    //kw40z_device.ToggleAdvertisementMode();
    kw40z_device.SendBatteryLevel(0);
}

void ButtonLeft(void)
{
    StartHaptic();
    //kw40z_device.ToggleAdvertisementMode();
    kw40z_device.SendBatteryLevel(1);
}
void ButtonUp(void)
{
    StartHaptic();
    //kw40z_device.ToggleAdvertisementMode();
    kw40z_device.SendBatteryLevel(2);
}

void ButtonDown(void)
{
    StartHaptic();
    //kw40z_device.ToggleAdvertisementMode();
    kw40z_device.SendBatteryLevel(3);
}

void PassKey(void)
{
    StartHaptic();
    strcpy((char *) text,"PAIR CODE");
    oled.TextBox((uint8_t *)text,0,25,95,18);
  
    /* Display Bond Pass Key in a 95px by 18px textbox at x=0,y=40 */
    sprintf(text,"%d", kw40z_device.GetPassKey());
    oled.TextBox((uint8_t *)text,0,40,95,18);
}

// Key modification: use the alert functionality enabled by the host-ble interface
// to define our own command.
void AlertReceived(uint8_t *data, uint8_t length)
{
    StartHaptic();
    data[19] = 0;
    pc.printf("%s\n\r", data);
    
    // data (our command) must 20 bytes long.
    // CMD for turning on: 'ledonledonledonledon'
    if (data[4] == 'n') {
        greenLed = LED_ON;
        redLed = LED_ON;
        blueLed = LED_ON;
        pc.printf("on\n\r", data);
    
    // CMD for turning off: 'ledoffledoffledoffled'
    } else if (data[4] == 'f') {
        greenLed = LED_OFF;
        redLed = LED_OFF;
        blueLed = LED_OFF;
        pc.printf("off\n\r", data);
    }
}
/***********************End of Call Back Functions*****************************/

/********************************Main******************************************/

int main()
{    
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_passkey(&PassKey);
    kw40z_device.attach_alert(&AlertReceived);
    
    accel.accel_config();

    pc.printf("hello\n\r");
    
    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();
    
    /* Fills the screen with solid black */         
    oled.FillScreen(COLOR_BLACK);

    /* Get OLED Class Default Text Properties */
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);    
        
    /* Change font color to Blue */ 
    textProperties.fontColor   = COLOR_BLUE;
    oled.SetTextProperties(&textProperties);
    
    /* Display Bluetooth Label at x=17,y=65 */ 
    strcpy((char *) text,"BLUETOOTH");
    oled.Label((uint8_t *)text,17,65);
    
    /* Change font color to white */ 
    textProperties.fontColor   = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);
    
    /* Display Label at x=22,y=80 */ 
    strcpy((char *) text,"Tap Below");
    oled.Label((uint8_t *)text,22,80);
         
    uint8_t prevLinkState = 0; 
    uint8_t currLinkState = 0;
     
    txThread.start(txTask); /*Start transmitting Sensor Tag Data */
    
    while (true) 
    {
        // blueLed = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/   
        Thread::wait(50);
    }
}

/******************************End of Main*************************************/

/* txTask() transmits the sensor data */
void txTask(void){
   
   while (true) 
   {
        GetSensorData();
        
        /*Notify Hexiwear App that it is running Sensor Tag mode*/
        kw40z_device.SendSetApplicationMode(GUI_CURRENT_APP_SENSOR_TAG);
                
        /*The following is sending dummy data over BLE. Replace with real data*/
    
        /*Send Battery Level for 20% */ 
        // SendAccel does not work and is not stable over bluetooth
        // So we will use SendBattery
        // But since SendBattery cannot send multiple values at a time
        // We will have to advertise to Pi what value it should expect next
    if(abs_x >50 && abs_z< 50){
        StartHaptic();
        kw40z_device.SendBatteryLevel(4);
        /* //Code for sending raw orientation data below
        kw40z_device.SendBatteryLevel('x');
        kw40z_device.SendBatteryLevel(abs_x);
        kw40z_device.SendBatteryLevel('y');
        kw40z_device.SendBatteryLevel(abs_y);
        kw40z_device.SendBatteryLevel('z');
        kw40z_device.SendBatteryLevel(abs_z);
        */
    }
        Thread::wait(1000);                 
    }
}

void GetSensorData(void) {
    accel.acquire_accel_data_g(accel_data);
    
    // get x,y,z data and amplify them by 100
    // convert x,y,z data to positive numbers since SendBattery only supports unsigned ints
    x = (int16_t)(accel_data[0] * 100);
    y = (int16_t)(accel_data[1] * 100);
    z = (int16_t)(accel_data[2] * 100);
    abs_x = abs(x);
    abs_y = abs(y);
    abs_z = abs(z);
    printf("ACCEL (x100)(ABS): X:%d Y:%d Z:%d\n",abs_x,abs_y,abs_z);
}

void StartHaptic(void)  {
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}

