#include "mbed.h"

// Variables
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);
Timer t;
int secTimer;

int main() {
    // set up
    pc.baud(38400);
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    t.start();
    secTimer = t.read_ms();
    // serial reading variables
    char temp;
    
    while(1) {
        // check serial
        if(pc.readable()){
            temp = pc.getc();
            if(temp == 'S'){
                // valid packet, continue parsing
                while(!pc.readable());
                temp = pc.getc(); // led1
                if(temp == '1'){
                    led1 = 1;
                }else if(temp == '0'){
                    led1 = 0;
                }
                while(!pc.readable());
                temp = pc.getc(); // led2
                if(temp == '1'){
                    led2 = 1;
                }else if(temp == '0'){
                    led2 = 0;
                }
                while(!pc.readable());
                temp = pc.getc(); // led3
                if(temp == '1'){
                    led3 = 1;
                }else if(temp == '0'){
                    led3 = 0;
                }
                while(!pc.readable());
                temp = pc.getc(); // led4
                if(temp == '1'){
                    led4 = 1;
                }else if(temp == '0'){
                    led4 = 0;
                }
                
            }
        }//end of parsing
        
        //relay status of LEDs to server, in case LEDs weren't set
        if((t.read_ms()- secTimer) > 1000){
            secTimer = t.read_ms();
            pc.putc('S');
            if(led1.read() == 1){
                pc.putc('1');
            }else{
                pc.putc('0');
            }
            if(led2.read() == 1){
                pc.putc('1');
            }else{
                pc.putc('0');
            }
            if(led3.read() == 1){
                pc.putc('1');
            }else{
                pc.putc('0');
            }
            if(led4.read() == 1){
                pc.putc('1');
            }else{
                pc.putc('0');
            }
        }
    }//end of infinite loop
    
}//end of main
