#include "mbed.h"
/*Inicializacion de objetos*/

Serial pc(USBTX, USBRX); // tx, rx
//                G   F   A   B   E    D   C  
BusOut dis_1(PTD4,PTA12,PTA4,PTA5,PTC8,PTC9,PTA13);
//                G   F   A   B   E    D   C  
BusOut dis_2(PTD4,PTA12,PTA4,PTA5,PTC8,PTC9,PTA13);
AnalogIn readv(PTB0);
AnalogIn readr(PTB1);
DigitalIn bot(PTE29);
DigitalIn bot2(PTE23);
DigitalOut led1(PTC7);
#define Num_datos 10
Timer tiempo_volt;
Timer tiempo_res;

/*Declaracion de variables*/
float volt[Num_datos];
float res[Num_datos];
int n;
int modo=0;
int prom_v=0;
int prom_r=0;
int i;
int entero;
int decimal;
/*Declaracion de variables*/
void desplegar_ero(int entero);
void desplegar_do(int decimal);

/*PROGRAMA PRINCIPAL*/
int main() {
    
    tiempo_volt.start();
    tiempo_res.start();
    while(1) {
       led1=1;
       wait(0.2);
       led1=0;
       wait(0.2);
       /*Se realizan n lecturas de voltaje por ciclo hasta llegar a 10*/
       if(tiempo_volt.read_ms()>500){
            for(i=1;i<=9; i++){
                n=i-1;
                volt[n]=volt[i];
            }
            n=0;
            volt[9]=readv*29;
            tiempo_volt.reset();
            if(prom_v!=10){
                prom_v++;
            }
        }
        
       /*Se realizan n lecturas de resistencia por ciclo hasta llegar a 10*/
        if(tiempo_res.read_ms()>500){
            for( i=1;i<=9; i++){
                n=i-1;
                res[n]=res[i];
            }
            n=0;
            res[9]=readr;
            tiempo_res.reset();
            if(prom_r!=10){
                prom_r++;
            }
        }
        /*elige lo que va a mostar, si resistencia o voltaje*/
        
        if(bot==0){
            modo=!modo;
            led1=modo;
        }
        /*Cuando el boton es presionado, a depender, nos realizara un promedio de los valores*/
        if(bot2==0){
            int prom = 0;
            if(modo==1){
                for(i=0;i<=9;i++){
                    prom = prom + volt[i];
                }
                prom=prom/prom_v;
            }else{
                for(i=0;i==9;i++){
                    prom = prom + res[i];
                }
                prom=prom/prom_r;
            }
            //llamaos las funciones para imprimir los valores
            pc.printf("%f \n ",&prom);
            entero = (int)prom/10;
            decimal = prom%10;
            desplegar_ero(entero);
            desplegar_do(decimal);
        }
        
    }
}
//Funciones para encender los displays
void desplegar_ero(int entero){
        switch(entero){
            case 0: 
                dis_1 = 63;
                break;
            case 1: 
                dis_1 = 9;
                break;
            case 2: 
                dis_1 = 94;
                break;
            case 3: 
                dis_1 = 91;
                break;
            case 4: 
                dis_1 = 105;
                break;
            case 5: 
                dis_1 = 115;
                break;
            case 6: 
                dis_1 = 119;
                break;
            case 7:
                dis_1 = 25;
                break;
            case 8:
                dis_1 = 127;
                break;
            case 9:
                dis_1 = 123;
                break;
            }
    }
    void desplegar_do(int decimal){
        switch(decimal){
            case 0: 
                dis_1 = 63;
                break;
            case 1: 
                dis_1 = 9;
                break;
            case 2: 
                dis_1 = 94;
                break;
            case 3: 
                dis_1 = 91;
                break;
            case 4: 
                dis_1 = 105;
                break;
            case 5: 
                dis_1 = 115;
                break;
            case 6: 
                dis_1 = 119;
                break;
            case 7:
                dis_1 = 25;
                break;
            case 8:
                dis_1 = 127;
                break;
            case 9:
                dis_1 = 123;
                break;
        }
    }