#include "mbed.h"
#include "keypad.h"
#include "TextLCD.h"

//Utilizar funciones del teclado 
#define       KEYLEN    4 //tamaño del vector
#define       ENDKEY   15//Guardar datos < que 3 cifras
#define       BORKEY   7//Borrar datos
#define       PASKEY   12//Pasar de parametro
#define       MENKEY   14//Guardar datos
//Se guardan los aprametros como una cadena de datos para luego convertirlos a un numero de 3 cifras
char          SP[KEYLEN]; 
char          KP[KEYLEN];
char          KI[KEYLEN];
char          KD[KEYLEN];
//Se definen las variables a utilizar
int           Index = 0;
int           p=0;
int           i=0;
int           c=1;
int           sp=0;
int           kp=0;
int           ki=0;
int           kd=0;

//Se DEclara los puertos de la pantalla LCD
TextLCD lcd(PTB10,PTB11,PTE2,PTE3,PTE4,PTE5);
// Se Declaran los puertos PTC2 PTE30
AnalogIn    me(PTC2);
AnalogOut   co(PTE30);

 
// se declara el teclado y el arreglo
int teclado[] = { 1,2,3,0,
                   4,5,6,0,
                   7,8,9,0,
                    0,0,0,0};


//Comienza programa:
uint32_t cbAfterInput(uint32_t tecla) {
    bool      finish = false;
    

    if (Index==0){
        if (tecla==PASKEY){
            p++;
            
                if (p==0){
                    lcd.locate(2,0);
                    lcd.printf(":");
                }
                if (p==1){
                    lcd.locate(10,0);
                    lcd.printf(":");
                 
                }
                if (p==2){
                    lcd.locate(2,1);
                    lcd.printf(":");
                }
                if (p==3){
                    lcd.locate(10,1);
                    lcd.printf(":");
                }   
                if (p==4){
                    lcd.locate(2,0);
                    lcd.printf(":");
                    p=0;
                }
            
                
        }
    }
    
   if(p==0){
        
              
        if (Index < KEYLEN - 1)
        {
            if ((tecla != ENDKEY) & (tecla != BORKEY) & (tecla != PASKEY)){
                SP[Index] = teclado[tecla];
                Index++;
                c--;
                    if (c==0){
                        lcd.locate(3,0);
                        lcd.printf("   ");
                        c=3;
                    }
                lcd.locate(3+i,0);
                lcd.printf("%d",SP[i]);
                i++;
                
            }
            
            if (tecla == ENDKEY){
                finish = true;
                c=1;
            }    
            
            if (tecla == BORKEY){
                memset(&SP, 0, KEYLEN);
                Index = 0;  
                i=0; 
                lcd.locate(3,0);
                lcd.printf("   ");
                c=1; 
                lcd.locate(2,0);
                lcd.printf("=");
            }

        }
 
        if (finish || (Index == KEYLEN - 1)) {
            sp=0;
            if (i==3){
                sp=(100*SP[0])+(10*SP[1])+(SP[2]);
            }
            if (i==2){
                sp=(10*SP[0])+(1*SP[1]);
            }
            if (i==1){
                sp=SP[0];
            }
            lcd.locate(3,0);
            lcd.printf("   ");
            
            lcd.locate(3,0);
            lcd.printf("%d",sp);
            memset(&SP, 0, KEYLEN);
            Index = 0;
            i=0;

        }
    }
 
 if(p==1){
        
        
      
        if (Index < KEYLEN - 1)
        {
            if ((tecla != ENDKEY) & (tecla != BORKEY) & (tecla != PASKEY)){
                KP[Index] = teclado[tecla];
                Index++;
                c--;
                    if (c==0){
                        lcd.locate(11,0);
                        lcd.printf("   ");
                        c=3;
                    }
                lcd.locate(11+i,0);
                lcd.printf("%d",KP[i]);
                i++;
                
            }
            
            if (tecla == ENDKEY){
                finish = true;
                c=1;
            }    
            
            if (tecla == BORKEY){
                memset(&KP, 0, KEYLEN);
                Index = 0;  
                i=0; 
                lcd.locate(11,0);
                lcd.printf("   ");
                c=1; 
                lcd.locate(10,0);
                lcd.printf("=");
            }

        }
 
        if (finish || (Index == KEYLEN - 1)) {
            kp=0;
            if (i==3){
                kp=(100*KP[0])+(10*KP[1])+(KP[2]);
            }
            if (i==2){
                kp=(10*KP[0])+(1*KP[1]);
            }
            if (i==1){
                kp=KP[0];
            }
            lcd.locate(11,0);
            lcd.printf("   ");
            
            lcd.locate(11,0);
            lcd.printf("%d",kp);
            memset(&KP, 0, KEYLEN);
            Index = 0;
            i=0;

        }
    }
 if(p==2){
        
        
      
        if (Index < KEYLEN - 1)
        {
            if ((tecla != ENDKEY) & (tecla != BORKEY) & (tecla != PASKEY)){
                KI[Index] = teclado[tecla];
                Index++;
                c--;
                    if (c==0){
                        lcd.locate(3,1);
                        lcd.printf("   ");
                        c=3;
                    }
                lcd.locate(3+i,1);
                lcd.printf("%d",KI[i]);
                i++;
                
            }
            
            if (tecla == ENDKEY){
                finish = true;
                c=1;
            }    
            
            if (tecla == BORKEY){
                memset(&KI, 0, KEYLEN);
                Index = 0;  
                i=0; 
                lcd.locate(3,1);
                lcd.printf("   ");
                c=1;
                lcd.locate(2,1);
                lcd.printf("="); 
            }

        }
 
        if (finish || (Index == KEYLEN - 1)) {
            ki=0;
            if (i==3){
                ki=(100*KI[0])+(10*KI[1])+(KI[2]);
            }
            if (i==2){
                ki=(10*KI[0])+(1*KI[1]);
            }
            if (i==1){
                ki=KI[0];
            }
            lcd.locate(3,1);
            lcd.printf("   ");
            
            lcd.locate(3,1);
            lcd.printf("%d",ki);
            memset(&KI, 0, KEYLEN);
            Index = 0;
            i=0;

        }
    }

if(p==3){
               
      
        if (Index < KEYLEN - 1)
        {
            if ((tecla != ENDKEY) & (tecla != BORKEY) & (tecla != PASKEY)){
                KD[Index] = teclado[tecla];
                Index++;
                c--;
                    if (c==0){
                        lcd.locate(11,1);
                        lcd.printf("   ");
                        c=3;
                    }
                lcd.locate(11+i,1);
                lcd.printf("%d",KD[i]);
                i++;
                
            }
            
            if (tecla == ENDKEY){
                finish = true;
                c=1;
            }    
            
            if (tecla == BORKEY){
                memset(&KD, 0, KEYLEN);
                Index = 0;  
                i=0; 
                lcd.locate(11,1);
                lcd.printf("   ");
                c=1;
                lcd.locate(10,1);
                lcd.printf("="); 
            }

        }
 
        if (finish || (Index == KEYLEN - 1)) {
            kd=0;
            if (i==3){
                kd=(100*KD[0])+(10*KD[1])+(KD[2]);
            }
            if (i==2){
                kd=(10*KD[0])+(1*KD[1]);
            }
            if (i==1){
                kd=KD[0];
            }
            lcd.locate(11,1);
            lcd.printf("   ");
            
            lcd.locate(11,1);
            lcd.printf("%d",kd);
            memset(&KD, 0, KEYLEN);
            Index = 0;
            i=0;

        }
    }
 
   if(tecla==MENKEY){//inicia control PID:
   
    float med,err,Sp,ap,ai,ad,PID,err_v,sal;
    med=err=Sp=ap=ai=ad=PID=err_v=sal=0;

    int k=0;
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("Guardado!!");
    wait(2);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Er=%.2f",err);
    lcd.locate(8,0);
    lcd.printf("Me=%.2f",med);
    lcd.locate(0,1);
    lcd.printf("Sp=0.00");    
    lcd.locate(8,1);
    lcd.printf("AC=%.2f",PID);
    

    
    while (1){
    wait(0.001);
        k++;
        med=me*3.3;
        Sp=(3.3/999)*sp;
        err=Sp-med;
        ap=kp*err;
        ai=(ki*err)+ai;
            if(ai>999){
                ai=999;
           }
        ad=kd*(err-err_v);
        PID=ap+ai+ad;
        
            if (PID<0){
                PID=0;
            }
            if (PID>999){
                PID=999;
            }  
        co=(PID/999);
        sal=co*3.3;
        err_v=err;
        
       
        if(k>100){
            
            lcd.locate(3,0);
            lcd.printf("     ");
            lcd.locate(3,0);
            lcd.printf("%.2f",err);
            lcd.locate(11,0);
            lcd.printf("     ");
            lcd.locate(11,0);
            lcd.printf("%.2f",med);
            lcd.locate(11,1);
            lcd.printf("     ");
            lcd.locate(11,1);
            lcd.printf("%.2f",sal);
            lcd.locate(3,1);
            lcd.printf("%.2f",Sp);
            k=0;            
        }
   
    }//while   
   
   }
   
   
   
   
    
        return 0;
}

 
int main() {
//Se elimina el bufer de los vectores
    memset(&SP, 0, KEYLEN);
    memset(&KP, 0, KEYLEN);
    memset(&KI, 0, KEYLEN);
    memset(&KD, 0, KEYLEN);
/***********************************************/
    Index = 0;
    Keypad keypad(PTA2,PTD4,PTD3,PTD1,PTA13,PTD5,PTD0,PTD2);
    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    lcd.writeCommand(0x0e);
    lcd.locate(0,0);
    lcd.printf("Sp:0");
    lcd.locate(8,0);
    lcd.printf("Kp:0");
    lcd.locate(0,1);
    lcd.printf("Ki:0");    
    lcd.locate(8,1);
    lcd.printf("Kd:0");    
    while (1) {
        
        
        wait(0.5);
        
    }
    
}
