#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"
#include "DebouncedIn.h"


//Defino donde conecto el LCD
TextLCD lcd(PTB8, PTB9, PTB10, PTB11, PTE2, PTE3); // rs, e, d4-d7 Teclado
DebouncedIn button1(PTB1); //Botón Aumento 
PulseInOut irda(PTB0);// en este puerto se pone el sensor infrarrojo

//DigitalOut led(LED1);
//DigitalOut led2(LED2);

int header =0; //tiempo de cabecera pulso abajo
const int head_H = 10884; //+20% medida con osciloscopio en microsegundos
const int head_L = 3680;//-20%  medida con osciloscopio
int i=0;
int v=1;
long cod, p, po;
const int T_alto=1730;//tiempo que dura un 1 lógico en microsegundos
const int T_bajo=633;//tiempo que dura un 0 lógico en micro segundos
const int num_bits = 32;//número de bits que posee el control remoto (sin contar el header)
int cont1=0;
int cont0=0;
int cant1=0;
int cant0=0;
float T_proma=0;
float T_promb=0;
int C1=0x0F;          // Codigo para escribir y matener el el LCD
int num[num_bits];    //cadena para almacenar todos los tiempos que conforman los bits de datos
int codigo[num_bits]; // Cadena para almacenar el codigo binario
int dato;             // tiempo de cada dato que se lee
  
int main(){
    lcd.writeCommand(C1);
    lcd.printf("    IRDA\n");
    wait(2);
    lcd.cls();
    lcd.printf("    EQUIPO1:\nJuan Jose Munoz");
    wait(2);
    lcd.cls();
    lcd.printf("Carlos Arbelaez Rafael Barriento");
    wait(2);
    lcd.cls();
    
     
while(1){
    
      lcd.writeCommand(C1);
      lcd.cls();
      lcd.printf("Presione un boton"); 
           
      header=0; // Se inicia la variable del header
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
      
      if (header > head_L && header < head_H) {
        
        for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(400);   
        }
      
            //ACTIVAR SI SE QUIEREN VER LOS VALORES DE LOS TTIEMPOS EN PANTALLA
            //wait(0.5); //se espera antes de leer todo el arreglo y ponerlo en pantalla 
            //for(i=0;i<(num_bits-1);++i){  
            //lcd.printf(",%d",num[i]);
            //     }
           
           
            wait(0.1);  //espero e imprimo en binario 
            lcd.cls();
            cant1=0;
            cant0=0;
            cont0=0;
            cont1=0;
            
            for(i=0;i<(num_bits-1);++i){  //Se construye el binario en un vector
             if(num[i] > ((T_alto+T_bajo)/2)){
                codigo[i]=1 ;
                cont1=cont1+num[i];
                cant1++;
             }
            else{ 
                codigo[i]=0;
                cont0=cont0+num[i]; 
                cant0++;
          }
        }
        T_proma=cont1/cant1;
        T_promb=cont0/cant0;
        //SE CONVIERTE EL BINARIO A DECIMAL
        cod=0;   //Se reinicia la variable cod 
        
        for(i=0;i<(num_bits-1);++i){  //Se convierte el binario a decimal
            
            if(codigo[i]==1){
               po=1;
            
               for(p=1; p<=i; ++p){
                     po=po*2;
                }
             cod=cod+po;
                    
                }    
            }
        }
      
      lcd.printf("Boton leido");
      i=0;
      v=1;
      while(i==0){
       
       if (button1.falling()){
      
       if (v==1){
       ++v;
       lcd.writeCommand(C1);
       lcd.cls();
       lcd.printf("Header time: \n %d \n", header);
       wait(1);
       
       }
       else if(v==2){
       ++v;
       lcd.writeCommand(C1);
       lcd.cls();
       lcd.printf("Codigo hex:\n %x\n", cod);
       }
       else if(v==3){
       ++v;    
       lcd.writeCommand(C1);
       lcd.cls();
       lcd.printf("Codigo decimal:\n%d\n", cod);
       }
       else if(v==4){
       ++v;
       lcd.writeCommand(C1);
       lcd.cls();
       lcd.printf("T_proma= %4.1f",T_proma);
        }
       else if(v==5){
       ++v;
       lcd.writeCommand(C1);
       lcd.cls();
       lcd.printf("T_promb= %4.1f",T_promb);
        }        
        else if (v==6){
       ++v;
       lcd.writeCommand(C1);
       lcd.cls();
       lcd.printf("Numero de bits  %d", cant0+cant1+1);
       wait(2);
       i=1;
       }
       } 
        
        } 
             
       }
       
       
      
     } 