#include "mbed.h"
#include "TextLCD.h"


Serial device(PTE0, PTE1);  // tx, rx
Serial pc(USBTX,USBRX);  // pc
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

char buffer[10]; // TAMAÑO DEL BUFER
Timer t;   //VALOR DEL TIEMPO
int c=0,d;

DigitalOut ledrojo(LED1); //rojo
DigitalOut ledverde(LED2); //verde
DigitalOut ledazul(LED3); //azul



int readBuffer(char *buffer,int count)   //esta funcion lee un bufer de datos
{
    int i=0;
    t.start();    //CUENTA EL TIEMPO DE CONEXION E INICIA
    while(1) {
        while (device.readable()) {
            char c = device.getc();
            if (c == '\r' || c == '\n') c = '$';//si se envia fin de linea o de caracter inserta $
            buffer[i++] = c;//mete al bufer el caracter leido
            if(i > count)break;//sale del loop si ya detecto terminacion
        }
        if(i > count)break;
        if(t.read() > 1) {  //MAS DE UN SEGUNDO DE ESPERA SE SALE Y REINICA EL RELOJ Y SE SALE
            t.stop();
            t.reset();
            break;
        }
    }
    return 0;
}

void cleanBuffer(char *buffer, int count)  //esta funcion limpia el bufer
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

int main()
{
    pc.baud(9600);   // asigno baudios y configuro puerto serie de la PC
    pc.format(8,Serial::None,1);

    device.baud(9600);   // asigno baudios y configuro device
    device.format(8,Serial::None,1);

    lcd.printf("ok"); // indica lcd funciona
    ledverde=0;
    ledrojo=1;
    ledazul=1;
    wait(1.5);
    lcd.cls(); //limpiar lcd
    ledverde=1;

    while(1) {
        if (device.readable()) {
            readBuffer(buffer,10);
            lcd.cls();
            lcd.printf("%s", buffer);
            ledazul=0;
            cleanBuffer(buffer, 10);
        }
    }
}
