
#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h"
#include "QEI.h"
#include "TextLCD.h"

// Definimos las salidas digitales a usar en la freescale
DigitalOut led1(LED2);
DigitalOut led2(LED1);
DigitalOut led3(LED3);

Rtc_Ds1307 rtc(PTE0, PTE1);

Serial pc(USBTX, USBRX, "pc");
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

//Aquí se configuran los puertos del encoder***********************************
QEI  wheel(PTA13, PTD5, NC, 100);

//Se programan los botones
DebouncedIn botonENC(PTC16); // botón propio del encoder
DebouncedIn boton2(PTC17);   // boton utilizado para confirmar

//Se inicializan las variables
int dia=0,mes=0,ano=2017,hora=0,minutos=0,segundos=0;
char buffer[128];
int readptr = 0;
int start=0, tiempoen=0;
int Config, pos=1,phora=1,palarma=1,palarma1=1, palarma2=1,palarma3=1, palarma4=1,palarma5=1,palarma6=1, p=1;

DigitalOut led(PTE31);//al transistor del led infrarrojo pin
DigitalIn button3(PTC17);//power
int i,j;
int t;

//*********************TIEMPO PARA TELEVISOR LG****************************************
int cabeceraL=8932;
int cabeceraH=4427;
int Tdescanso=574;
int Tlow=570;
int Thigh=1645;
int duracion; //duracion de un pulso bajo
int numb = 33;
void pwr();
void repeat();
int sendcode(int numb, int *code, int cabeceraL, int cabeceraH, int Tdescanso, int Tlow, int Thigh);
int code[65];
int dato[65];
int descanso(int duracion);
Timer r;

const unsigned pwrc[]= {533,533,1643,536,536,538,538,539,1648,1650,532,1641,1643,1644,1645,
                        1646,539,541,541,1651,532,534,534,535,1644,1646,1647,540,1650,1640,1641,1644
                       };

int main()
{

//defino reloj y alamra
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc alarma = {};
    Rtc_Ds1307::Time_rtc alarma1 = {};
    Rtc_Ds1307::Time_rtc alarma2 = {};
    Rtc_Ds1307::Time_rtc alarma3 = {};
    Rtc_Ds1307::Time_rtc alarma4 = {};
    Rtc_Ds1307::Time_rtc alarma5 = {};
    Rtc_Ds1307::Time_rtc alarma6 = {};

//menu inicio muestra la hora y las opcinoes para configrar las alarmas y la
// hora, para cambiar de opcioon boton del encoder y para seleccionar boton2

reloj:

    lcd.locate(0,1);
    lcd.printf("->hora    tiempo");


    while(1) {

        rtc.startClock();
        rtc.getTime(tm);
        lcd.locate(0,0);
        lcd.printf("%02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
        if (botonENC.falling()) { //cambia la posicion de ingreso de parametros
            if(pos==2) {
                pos=1;
                lcd.locate(0,1);
                lcd.printf("->");
                lcd.locate(8,1);
                lcd.printf("  ");
            } else if (pos==1) {
                pos=2;
                lcd.locate(8,1);
                lcd.printf("->");
                lcd.locate(0,1);
                lcd.printf("  ");
            }
            wait(1);
        }
        if(boton2.falling()) {
            if(pos==1) {
                goto hora;
            }
            if(pos==2) {
                goto alarm;
            }
        }

//Revisar si hay alguna alarma que debe activarse*******************************************************************************
        if( (tm.date==alarma.date)&&(tm.mon==alarma.mon)&&(tm.year==alarma.year)&&(tm.hour==alarma.hour)&&(tm.min==alarma.min)&&(tm.sec==alarma.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if( (tm.date==alarma1.date)&&(tm.mon==alarma1.mon)&&(tm.year==alarma1.year)&&(tm.hour==alarma1.hour)&&(tm.min==alarma1.min)&&(tm.sec==alarma1.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if( (tm.date==alarma2.date)&&(tm.mon==alarma2.mon)&&(tm.year==alarma2.year)&&(tm.hour==alarma2.hour)&&(tm.min==alarma2.min)&&(tm.sec==alarma2.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if( (tm.date==alarma3.date)&&(tm.mon==alarma3.mon)&&(tm.year==alarma3.year)&&(tm.hour==alarma3.hour)&&(tm.min==alarma3.min)&&(tm.sec==alarma3.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if( (tm.date==alarma4.date)&&(tm.mon==alarma4.mon)&&(tm.year==alarma4.year)&&(tm.hour==alarma4.hour)&&(tm.min==alarma4.min)&&(tm.sec==alarma4.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if( (tm.date==alarma5.date)&&(tm.mon==alarma5.mon)&&(tm.year==alarma5.year)&&(tm.hour==alarma5.hour)&&(tm.min==alarma5.min)&&(tm.sec==alarma5.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if( (tm.date==alarma6.date)&&(tm.mon==alarma6.mon)&&(tm.year==alarma6.year)&&(tm.hour==alarma6.hour)&&(tm.min==alarma6.min)&&(tm.sec==alarma6.sec) ) {
            pwr();
            r.start();
            led1=1;
            wait(0.5);
            led1=0;
        }
        if((r.read()*10000)>tiempoen*60*10000) { //comparo el tiempo de encendido con el del timer se multiplica por 10000 para evitar aproximaciones
            pwr();
            r.reset();
            r.stop();
            led2=1;
            wait(0.5);
            led2=0;
        }

    }

//configuro la hora y la fecha**************************************************
hora:
    lcd.cls();
    if (pos==1) {
        while(phora==1) {
            dia=wheel.getPulses();
            lcd.locate(0,0);
            lcd.printf("dia(fecha 0..31)");// Se pide ingresar un número del 0
            // al 31 equivalente al día del mess
            if(dia>31) {
                dia=0;
                wheel.reset();
            }
            if(dia<0) {
                dia=0;
                wheel.reset();
            }
            lcd.locate(5,1);
            lcd.printf(" ");
            lcd.locate(0,1);
            lcd.printf("dia=%d",dia);

            if(boton2.falling()) {
                phora=2;
                tm.date=dia;
                wheel.reset();
                lcd.cls();
            }
            wait(0.5);
        }
        while(phora==2) {
            mes=wheel.getPulses();
            lcd.locate(0,0);
            lcd.printf("mes (1...,12");// Se pide ingresar un número del 1 al 12
            if(mes<0) {
                mes=0;
                wheel.reset();
            }
            if(mes>12) {
                mes=0;
                wheel.reset();
            }
            lcd.locate(5,1);
            lcd.printf(" ");
            lcd.locate(0,1);
            lcd.printf("mes=%d",mes);

            if(boton2.falling()) {
                phora=3;
                tm.mon=mes;
                wheel.reset();
                lcd.cls();
            }
            wait(0.5);
        }
        while(phora==3) {
            ano=2017+wheel.getPulses();
            lcd.locate(0,0);
            lcd.printf("año");// Se pide ingresar un número del 2017 al ....
            lcd.locate(0,1);
            lcd.printf("año=%d",ano);
            if(ano<2017) {
                ano=2017;
                wheel.reset();
            }
            if(boton2.falling()) {
                phora=4;
                tm.year=ano;
                wheel.reset();
                lcd.cls();
            }
        }
        while(phora==4) {
            hora=wheel.getPulses();
            lcd.locate(0,0);
            lcd.printf("hora formato 24");// Se pide ingresar la hora en formato 24 horas
            if(hora<0) {
                hora=0;
                wheel.reset();
            }
            if(hora>23) {
                hora=0;
                wheel.reset();
            }
            lcd.locate(6,1);
            lcd.printf("  ");
            lcd.locate(0,1);
            lcd.printf("hora=%d",hora);

            if(boton2.falling()) {
                phora=5;
                tm.hour=hora;
                wheel.reset();
                lcd.cls();
            }
            wait(1);
        }
        while(phora==5) {
            minutos=wheel.getPulses();
            lcd.locate(0,0);
            lcd.printf("minutos");// Se pide ingresar los minutos
            if(minutos<0) {
                hora=0;
                wheel.reset();
            }
            if(minutos>59) {
                minutos=0;
                wheel.reset();
            }
            lcd.locate(9,1);
            lcd.printf(" ");
            lcd.locate(0,1);
            lcd.printf("minutos=%d",minutos);

            if(boton2.falling()) {
                phora=6;
                tm.min=minutos;
                wheel.reset();
                lcd.cls();
            }
            wait(1);
        }
        while(phora==6) {
            segundos=wheel.getPulses();
            lcd.locate(0,0);
            lcd.printf("segundos");// Se pide ingresar los minutos
            if(segundos<0) {
                segundos=0;
                wheel.reset();
            }
            if(segundos>59) {
                segundos=0;
                wheel.reset();
            }
            lcd.locate(9,1);
            lcd.printf(" ");
            lcd.locate(0,1);
            lcd.printf("segundos=%d",segundos);

            if(boton2.falling()) {
                tm.sec=segundos;
                wheel.reset();
                lcd.cls();
                pos=1;
                phora=1;
                rtc.setTime(tm, false, false); ////////////////////////////////
                //////////////////////////////////////////////
                goto reloj;
            }
            wait(1);
        }
    }

// se configuran las alarmas ***************************************************
alarm:
    while(1) {
        lcd.cls();
        while(p==1) {
            lcd.locate(0,0);
            lcd.printf("P1:%02d:%02d:%02d\n ", alarma.hour, alarma.min, alarma.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarmac;
            }
            if (boton2.falling()) {
                p++;
            }
            wait(0.5);
        }
        while(p==2) {
            lcd.locate(0,0);
            lcd.printf("P2:%02d:%02d:%02d\n ", alarma1.hour, alarma1.min, alarma1.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarma1c;
            }
            if (boton2.falling()) {
                p++;
            }
            wait(0.5);
        }
        while(p==3) {
            lcd.locate(0,0);
            lcd.printf("P3:%02d:%02d:%02d\n",alarma2.hour, alarma2.min, alarma2.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarma2c;
            }
            if (boton2.falling()) {
                p++;
            }
            wait(0.5);
        }
        while(p==4) {
            lcd.locate(0,0);
            lcd.printf("P4:%02d:%02d:%02d\n", alarma3.hour, alarma3.min, alarma3.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarma3c;
            }
            if (boton2.falling()) {
                p++;
            }
            wait(0.5);
        }
        while(p==5) {
            lcd.locate(0,0);;
            lcd.printf("P5:%02d:%02d:%02d\n", alarma4.hour, alarma4.min, alarma4.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarma4c;
            }
            if (boton2.falling()) {
                p++;
            }
            wait(0.5);
        }
        while(p==6) {
            lcd.locate(0,0);;
            lcd.printf("P6:%02d:%02d:%02d\n", alarma5.hour, alarma5.min, alarma5.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarma5c;
            }
            if (boton2.falling()) {
                p++;
            }
            wait(0.5);
        }
        while(p==7) {
            lcd.locate(0,0);
            lcd.printf("P7:%02d:%02d:%02d\n", alarma6.hour, alarma6.min, alarma6.sec);
            lcd.locate(0,1);
            lcd.printf("ENC-conf B2-sig"); //boton 1 (enconcoder) para configurar la
            // alarama y boton 2 para ver siguiente alarma
            if (botonENC.falling()) {
                goto alarma6c;
            }
            if (boton2.falling()) {
                p=1;
                lcd.cls();
                goto reloj;
            }
            wait(0.5);
        }
    }

alarmac:
    lcd.cls();
    while(palarma==1) {
        alarma.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P1");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma.date>31) {
            alarma.date=0;
            wheel.reset();
        }
        if(alarma.date<0) {
            alarma.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma.date);

        if(boton2.falling()) {
            palarma=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma==2) {
        alarma.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P1");// Se pide ingresar un número del 1 al 12
        if(alarma.mon<0) {
            alarma.mon=0;
            wheel.reset();
        }
        if(alarma.mon>12) {
            alarma.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma.mon);

        if(boton2.falling()) {
            palarma=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma==3) {
        alarma.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P1");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma.year);
        if(alarma.year<2017) {
            alarma.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma==4) {
        alarma.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P1");// Se pide ingresar la hora en formato 24 horas
        if(alarma.hour<0) {
            alarma.hour=0;
            wheel.reset();
        }
        if(alarma.hour>23) {
            alarma.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma.hour);

        if(boton2.falling()) {
            palarma=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma==5) {
        alarma.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P1");// Se pide ingresar los minutos
        if(alarma.min<0) {
            alarma.min=0;
            wheel.reset();
        }
        if(alarma.min>59) {
            alarma.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma.min);

        if(boton2.falling()) {
            palarma=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma==6) {
        alarma.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P1");// Se pide ingresar los minutos
        if(alarma.sec<0) {
            alarma.sec=0;
            wheel.reset();
        }
        if(alarma.sec>59) {
            alarma.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma.sec);

        if(boton2.falling()) {
            wheel.reset();
            palarma=7;
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma==7) {
        tiempoen=wheel.getPulses();
        if (tiempoen<0) {
            tiempoen=0;
        }
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma=1;
            goto alarm;
        }
        wait(0.5);
    }

alarma1c:
    lcd.cls();
    while(palarma1==1) {
        alarma1.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P2");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma1.date>31) {
            alarma1.date=0;
            wheel.reset();
        }
        if(alarma1.date<0) {
            alarma1.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma1.date);

        if(boton2.falling()) {
            palarma1=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma1==2) {
        alarma1.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P2");// Se pide ingresar un número del 1 al 12
        if(alarma1.mon<0) {
            alarma1.mon=0;
            wheel.reset();
        }
        if(alarma1.mon>12) {
            alarma1.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma1.mon);

        if(boton2.falling()) {
            palarma1=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma1==3) {
        alarma1.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P2");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma1.year);
        if(alarma1.year<2017) {
            alarma1.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma1=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma1==4) {
        alarma1.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P2");// Se pide ingresar la hora en formato 24 horas
        if(alarma1.hour<0) {
            alarma1.hour=0;
            wheel.reset();
        }
        if(alarma1.hour>23) {
            alarma1.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma1.hour);

        if(boton2.falling()) {
            palarma1=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma1==5) {
        alarma1.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P2");// Se pide ingresar los minutos
        if(alarma1.min<0) {
            alarma1.min=0;
            wheel.reset();
        }
        if(alarma1.min>59) {
            alarma1.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma1.min);

        if(boton2.falling()) {
            palarma1=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma1==6) {
        alarma1.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P2");// Se pide ingresar los minutos
        if(alarma1.sec<0) {
            alarma1.sec=0;
            wheel.reset();
        }
        if(alarma1.sec>59) {
            alarma1.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma1.sec);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma1=7;
        }
        wait(0.5);
    }
    while(palarma1==7) {
        tiempoen=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma1=1;
            goto alarm;
        }
        wait(0.5);
    }
alarma2c:
    lcd.cls();
    while(palarma2==1) {
        alarma2.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P3");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma2.date>31) {
            alarma2.date=0;
            wheel.reset();
        }
        if(alarma2.date<0) {
            alarma2.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma2.date);

        if(boton2.falling()) {
            palarma2=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma2==2) {
        alarma1.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P3");// Se pide ingresar un número del 1 al 12
        if(alarma2.mon<0) {
            alarma2.mon=0;
            wheel.reset();
        }
        if(alarma2.mon>12) {
            alarma2.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma2.mon);

        if(boton2.falling()) {
            palarma2=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma2==3) {
        alarma2.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P3");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma2.year);
        if(alarma2.year<2017) {
            alarma2.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma2=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma2==4) {
        alarma2.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P3");// Se pide ingresar la hora en formato 24 horas
        if(alarma2.hour<0) {
            alarma2.hour=0;
            wheel.reset();
        }
        if(alarma2.hour>23) {
            alarma2.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma2.hour);

        if(boton2.falling()) {
            palarma2=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma2==5) {
        alarma2.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P3");// Se pide ingresar los minutos
        if(alarma2.min<0) {
            alarma2.min=0;
            wheel.reset();
        }
        if(alarma2.min>59) {
            alarma2.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma2.min);

        if(boton2.falling()) {
            palarma2=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma2==6) {
        alarma2.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P3");// Se pide ingresar los minutos
        if(alarma2.sec<0) {
            alarma2.sec=0;
            wheel.reset();
        }
        if(alarma2.sec>59) {
            alarma2.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma2.sec);

        if(boton2.falling()) {
            tm.sec=segundos;
            wheel.reset();
            lcd.cls();
            palarma2=7;
        }
        wait(0.5);
    }
    while(palarma2==7) {
        tiempoen=wheel.getPulses();
        if (tiempoen<0) {
            tiempoen=0;
            wheel.reset();
        }
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma2=1;
            goto alarm;
        }
        wait(0.5);
    }
alarma3c:
    lcd.cls();
    while(palarma3==1) {
        alarma3.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P4");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma3.date>31) {
            alarma3.date=0;
            wheel.reset();
        }
        if(alarma3.date<0) {
            alarma3.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma3.date);

        if(boton2.falling()) {
            palarma3=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma3==2) {
        alarma3.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P4");// Se pide ingresar un número del 1 al 12
        if(alarma3.mon<0) {
            alarma3.mon=0;
            wheel.reset();
        }
        if(alarma3.mon>12) {
            alarma3.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma3.mon);

        if(boton2.falling()) {
            palarma3=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma3==3) {
        alarma3.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P4");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma3.year);
        if(alarma3.year<2017) {
            alarma3.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma3=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma3==4) {
        alarma3.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P4");// Se pide ingresar la hora en formato 24 horas
        if(alarma3.hour<0) {
            alarma3.hour=0;
            wheel.reset();
        }
        if(alarma3.hour>23) {
            alarma3.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma3.hour);

        if(boton2.falling()) {
            palarma3=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma3==5) {
        alarma3.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P4");// Se pide ingresar los minutos
        if(alarma3.min<0) {
            alarma3.min=0;
            wheel.reset();
        }
        if(alarma3.min>59) {
            alarma3.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma3.min);

        if(boton2.falling()) {
            palarma3=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma3==6) {
        alarma3.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P4");// Se pide ingresar los minutos
        if(alarma3.sec<0) {
            alarma3.sec=0;
            wheel.reset();
        }
        if(alarma3.sec>59) {
            alarma3.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma3.sec);

        if(boton2.falling()) {
            tm.sec=segundos;
            wheel.reset();
            lcd.cls();
            palarma3=7;
        }
        wait(0.5);
    }
    while(palarma3==7) {
        tiempoen=wheel.getPulses();
        if (tiempoen<0) {
            tiempoen=0;
            wheel.reset();
        }
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma3=1;
            goto alarm;
        }
        wait(0.5);
    }
alarma4c:
    lcd.cls();
    while(palarma4==1) {
        alarma4.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P5");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma4.date>31) {
            alarma4.date=0;
            wheel.reset();
        }
        if(alarma4.date<0) {
            alarma4.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma4.date);

        if(boton2.falling()) {
            palarma4=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma4==2) {
        alarma4.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P5");// Se pide ingresar un número del 1 al 12
        if(alarma4.mon<0) {
            alarma4.mon=0;
            wheel.reset();
        }
        if(alarma4.mon>12) {
            alarma4.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma4.mon);

        if(boton2.falling()) {
            palarma4=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma4==3) {
        alarma4.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P5");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma4.year);
        if(alarma4.year<2017) {
            alarma4.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma4=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma4==4) {
        alarma4.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P5");// Se pide ingresar la hora en formato 24 horas
        if(alarma4.hour<0) {
            alarma4.hour=0;
            wheel.reset();
        }
        if(alarma4.hour>23) {
            alarma4.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma4.hour);

        if(boton2.falling()) {
            palarma4=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma4==5) {
        alarma4.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P5");// Se pide ingresar los minutos
        if(alarma4.min<0) {
            alarma4.min=0;
            wheel.reset();
        }
        if(alarma4.min>59) {
            alarma4.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma4.min);

        if(boton2.falling()) {
            palarma4=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma4==6) {
        alarma4.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P5");// Se pide ingresar los minutos
        if(alarma1.sec<0) {
            alarma1.sec=0;
            wheel.reset();
        }
        if(alarma4.sec>59) {
            alarma4.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma4.sec);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma4=7;
        }
    }
    while(palarma4==7) {
        tiempoen=wheel.getPulses();
        if (tiempoen<0) {
            tiempoen=0;
            wheel.reset();
        }
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma4=1;
            goto alarm;
        }
        wait(0.5);
    }
alarma5c:
    lcd.cls();
    while(palarma5==1) {
        alarma5.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P6");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma5.date>31) {
            alarma5.date=0;
            wheel.reset();
        }
        if(alarma5.date<0) {
            alarma5.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma5.date);

        if(boton2.falling()) {
            palarma5=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma5==2) {
        alarma5.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P6");// Se pide ingresar un número del 1 al 12
        if(alarma5.mon<0) {
            alarma5.mon=0;
            wheel.reset();
        }
        if(alarma5.mon>12) {
            alarma5.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma5.mon);

        if(boton2.falling()) {
            palarma5=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma5==3) {
        alarma5.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P6");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma5.year);
        if(alarma5.year<2017) {
            alarma5.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma5=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma5==4) {
        alarma5.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P6");// Se pide ingresar la hora en formato 24 horas
        if(alarma5.hour<0) {
            alarma5.hour=0;
            wheel.reset();
        }
        if(alarma5.hour>23) {
            alarma5.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma5.hour);

        if(boton2.falling()) {
            palarma5=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma5==5) {
        alarma5.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P6");// Se pide ingresar los minutos
        if(alarma5.min<0) {
            alarma5.min=0;
            wheel.reset();
        }
        if(alarma5.min>59) {
            alarma5.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma5.min);

        if(boton2.falling()) {
            palarma5=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma5==6) {
        alarma5.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P6");// Se pide ingresar los minutos
        if(alarma5.sec<0) {
            alarma5.sec=0;
            wheel.reset();
        }
        if(alarma5.sec>59) {
            alarma5.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma5.sec);

        if(boton2.falling())
            wheel.reset();
        lcd.cls();
        palarma5=7;
    }

    while(palarma5==7) {
        tiempoen=wheel.getPulses();
        if (tiempoen<0) {
            tiempoen=0;
            wheel.reset();
        }
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma5=1;
            goto alarm;
        }
        wait(0.5);
    }

alarma6c:
    lcd.cls();
    while(palarma6==1) {
        alarma5.date=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("dia P7");// Se pide ingresar un número del 0 al 31 equivalente al día del mess
        if(alarma6.date>31) {
            alarma6.date=0;
            wheel.reset();
        }
        if(alarma6.date<0) {
            alarma6.date=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("dia=%d",alarma6.date);

        if(boton2.falling()) {
            palarma6=2;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma6==2) {
        alarma6.mon=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("mes P7");// Se pide ingresar un número del 1 al 12
        if(alarma6.mon<0) {
            alarma6.mon=0;
            wheel.reset();
        }
        if(alarma6.mon>12) {
            alarma6.mon=0;
            wheel.reset();
        }
        lcd.locate(5,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("mes=%d",alarma6.mon);

        if(boton2.falling()) {
            palarma6=3;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma6==3) {
        alarma6.year=2017+wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("año P7");// Se pide ingresar un número del 2017 al ....
        lcd.locate(0,1);
        lcd.printf("año=%d",alarma6.year);
        if(alarma6.year<2017) {
            alarma6.year=2017;
            wheel.reset();
        }
        if(boton2.falling()) {
            palarma6=4;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma6==4) {
        alarma6.hour=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("hora P7");// Se pide ingresar la hora en formato 24 horas
        if(alarma6.hour<0) {
            alarma6.hour=0;
            wheel.reset();
        }
        if(alarma6.hour>23) {
            alarma6.hour=0;
            wheel.reset();
        }
        lcd.locate(6,1);
        lcd.printf("  ");
        lcd.locate(0,1);
        lcd.printf("hora=%d",alarma6.hour);

        if(boton2.falling()) {
            palarma6=5;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma6==5) {
        alarma5.min=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("minutos P7");// Se pide ingresar los minutos
        if(alarma6.min<0) {
            alarma6.min=0;
            wheel.reset();
        }
        if(alarma6.min>59) {
            alarma6.min=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("minutos=%d",alarma6.min);

        if(boton2.falling()) {
            palarma6=6;
            wheel.reset();
            lcd.cls();
        }
        wait(0.5);
    }
    while(palarma6==6) {
        alarma6.sec=wheel.getPulses();
        lcd.locate(0,0);
        lcd.printf("segundos P7");// Se pide ingresar los minutos
        if(alarma6.sec<0) {
            alarma6.sec=0;
            wheel.reset();
        }
        if(alarma6.sec>59) {
            alarma6.sec=0;
            wheel.reset();
        }
        lcd.locate(9,1);
        lcd.printf(" ");
        lcd.locate(0,1);
        lcd.printf("segundos=%d",alarma6.sec);

        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma6=7;
        }
        wait(1);
    }
    while(palarma6==7) {
        tiempoen=wheel.getPulses();
        if (tiempoen<0) {
            tiempoen=0;
            wheel.reset();
        }
        lcd.locate(0,0);
        lcd.printf("tiempo encendido (minutos)");
        lcd.locate(0,1);
        lcd.printf("%i minutos",tiempoen);
        if(boton2.falling()) {
            wheel.reset();
            lcd.cls();
            palarma6=1;
            goto alarm;
        }
        wait(0.5);
    }
}


/*********************************************************Funciones *******************************************************************/
int descanso(int duracion)
{
    Timer t;
    t.reset();
    t.start();
    while(1) {
        led=1;
        wait_us(8);
        led=0;
        led=0;
        wait_us(9);
        if(t.read_us() > duracion) {
            return 0;
        }

    }
}

int sendcode(int numb, int *code, int cabeceraL, int cabeceraH, int Tdescanso, int Tlow, int Thigh)
{
    led=0;
    wait_ms(100);
    descanso(cabeceraL);
    wait_us(cabeceraH);

    for(i=0; i<numb; i++) {
        if (code[i]>1000) {
            descanso(Tdescanso);
            wait_us(Thigh);
        }
        if (code[i]<1000) {
            descanso(Tdescanso);
            wait_us(Tlow);
        }
    }
    descanso(Tdescanso);
    return 0;
}
void pwr()
{
    for(i=0; i<numb; i++) {
        code[i]=pwrc[i];
    }
    sendcode(numb,code,cabeceraL, cabeceraH, Tdescanso, Tlow, Thigh);
}
void repeat()
{
    wait_ms(42);
    descanso(8800);
    wait_us(2240);
    descanso(560);
}

