//timer

#include "mbed.h"
 
//10の割り算 0から1028までは、正しい。主に0から999
#define DVI10(n) ((n*205)>>11)
 
//1000の割り算 180000までは、ほぼ正しい　ミリ秒を切り捨てす為に精度は、不要
#define DVI1000(n3)     (((n3>>3)*4195)>>19)

//6の割り算 主に18まで
#define DVI6(n6)        ((n6*683)>>12)
 
//Serial pc(USBTX, USBRX); // tx, rx
//Serial pc(SERIAL_TX, SERIAL_RX); //767
//Serial pc(PA_2, PA_3); //010
//Serial pc(PA_9, PA_10); //010
Serial pc(dp16, dp15); // tx, rx 1114

#define UART_DELAY (96) //  1/9600

//仮想シリアルの出力ポート
//DigitalOut TX(PA_9); //010
//DigitalOut TX(PA_2); //010
DigitalOut TX(dp9); //1114


//DigitalOut myled(D13);    //767
//DigitalOut myled(PA_4);   //010
DigitalOut myled(dp14); //1114

//タイマーの定義
Timer t;

int q_st; //スタートタイム debug
int q_et; //エンドタイム   debug

//仮想シリアルへの一文字出力 9600bps
int pc_putc(char ch) {

    TX=1;
    
    q_st = t.read_us(); //debug
    
    TX=0;//START
    wait_us(UART_DELAY);
    
    for(int ii=0;ii<8;ii++){
        TX=(ch>>ii)&1;
        wait_us(UART_DELAY);
    }; //for

    TX=1;//Stop
    wait_us(UART_DELAY);

    q_et = t.read_us(); //debug 引いた数が0で1041ufなら正解
         
    return(0);
    
} //pc_putc

//文字列の表示
int pc_printf(char *str1) {

    //文字の中身がゼロか
    while(*str1){
            
        //一文字出力
        pc_putc(*str1 ++);
                        
    } //while

    //戻り値
    return(0);
}//pc_printf

//10文字分のバッファー
char str10[10];

//d int l_num,aaa,bbb,ccc,qqq; //debug
//d char ch_hex_a_b[10];   //debug

int main() {

    //初期化
    TX=1;wait_ms(2);    //文字分のウエート
    pc_printf("\r\n");  //ゴミの吐き出し
        
//d    pc_printf("\r\n");
//d    pc_printf("Hello World!\r\n");
    
    //タイマーの開始
    t.start();
    //pc.printf("Hello World!\r\n");
    //t.stop();

 /*
    //dbbug
    int l_num,aaa,bbb,ccc; //debug
    char ch_hex_a_b[10];   //debug
    for(int ll=0;ll<40;ll++){
        pc_putc('A');
        l_num = (q_et-q_st)/10;
        //pc.printf("\t%d\r\n",(q_et-q_st)); //767
        bbb=DVI10(l_num);
        ccc=l_num-(bbb*10);
        l_num=bbb;
        aaa=DVI10(l_num);
        bbb=l_num-(aaa*10);
        ch_hex_a_b[0] = '0' + aaa;
        ch_hex_a_b[1] = '0' + bbb;
        ch_hex_a_b[2] = '0' + ccc;
        ch_hex_a_b[3] = 'X';
        ch_hex_a_b[4] = 'u';
        ch_hex_a_b[5] = 'S';
        ch_hex_a_b[6] = 0;
        pc_printf(ch_hex_a_b);
        pc_printf("\r\n");
        wait_ms(1000);
    }//for
    pc_printf("\r\n"); //debbug
 */

    //初期値の表示
    pc_printf("0m00s\r\n");

    //最初のウエート
    wait_ms(990);

    int a,b,c,d,e; //分秒
    int a_bk=0;    //秒のバックアップ

    //無限ループ
    while(1) { 
        //pc.printf("The time taken was %f seconds\r\n", t.read()); //767
        //pc.printf("The time taken was %d seconds\r\n",  DVI1000( t.read_ms() )  ); //767
        
        //秒が変わるまで待つ
        while(1) {
            a = DVI1000( t.read_ms() ); //秒
            if( a != a_bk) {break;}
        }//while
        a_bk=a; //値を保存
                
        //1秒毎のブリンク
        myled = 1;
        wait_ms(10);
        myled = 0;
        
        //秒から分の分離
        b = DVI10( a ); //1シフト 123秒の時は、12が戻る
        c = a - (b*10); //1の桁 123秒の時は、3が戻る
        d = DVI6( b ); //分 12の時は、3分
        e = b - ( d * 6 ); // 秒の10の桁　12- 3分*6 = 0
        //pc.printf("%d %t %d %t %d \r\n",  d , e , c  ); //767
        
        //分秒の表示
        str10[0] = ('0'+d);
        str10[1] = ('m');
        str10[2] = ('0'+e);
        str10[3] = ('0'+c);
        str10[4] = ('s');
        str10[5] = ('\r');
        str10[6] = ('\n'); 
        str10[7] = (0); 
        pc_printf(str10);
        
        //3分経ったらループを停止してブリンク
        if( a == 180 /*3分*/ ) {
            while(1){
                myled = 1;
                wait_ms(500);
                myled = 0;
                wait_ms(500);
            }//while
        }//if
         
        //pc.printf("The time taken was %d seconds\r\n", t.read_ms()); //767
        //pc.printf("The time taken was %d seconds\r\n", t.read_us()); //767
        
        //約1秒を待つ
        wait_ms(980);
    } //while

} //main

////容量削減
//void error(const char* format, ...){}
