#include "stm32f103c8t6.h"
#include "mbed.h"
#include "USBSerial.h"

USBSerial usbSerial(0x1f00, 0x2012, 0x0001,  false);    // connection is not blocked when USB is not plugged in
//Serial    pc(PA_2, PA_3);

//DigitalOut  myled(LED1);

DigitalOut myled(PA_7);
                  //     65432109876543210
int on1  = GPIOA->ODR | 0b0000000010000000;
int off1 = GPIOA->ODR & 0b1111111101111111;

int l[90]; //max30 led

void bit_on1();
void bit_off1();

//             12345678   12345678   12345678   12345678
int b8[8] = {0b10000000,0b01000000,0b00100000,0b00010000,
             0b00001000,0b00000100,0b00000010,0b00000001, };

int ws_led(int num1)
{
    int on_off;

    //__disable_irq(); // disable interrupt
    //__enable_irq(); // enable interrupt

    //GPIO bkup
    //int g_bk  = GPIOA->ODR;


    for(int ii=0;ii<num1;ii++){
        //pc.printf("  -%d\t%d\r\n",ii,l[ii]); //303

        //8ビット分送る
        for(int jj=0;jj<8;jj++){
            //pc.printf("  -%d\r\n",jj); //103

            on_off = l[ii] & b8[jj];

            if( on_off == 0 ){
                //ビットが0
                //pc.printf("0"); //103
                bit_off1();
            } else {
                //ビットが1 
                //pc.printf("1"); //103
                bit_on1();
            }//endif

        }//for 8bit


    }//for max30byt

    //__disable_irq(); // disable interrupt
    //__enable_irq(); // enable interrupt

    //GPIO bkup
    //GPIOA->ODR = g_bk;

    return(0);
}


////////////////////////////


char *hex_b_c(int i_num);

int  ch_len;
char ch_b[9+1]; //文字列のバッファー
char *ch_input()
{
    int  ch_i=0;    //文字列のループカウンター
    int  ch_y;      //一文字分の一時バッファー
    int  ii;        //ループカウンター

    ch_len=0;
    //最初データ待ち
    while(1) {      if( usbSerial.available() > 0 ) {break;}  }

    while(1) {

        //バッファーにデータがあるか
        for(ii=0;ii<500;ii++){
            wait_ms(1);
            if(usbSerial.available() > 0) {break;}
        }//for


        if(ii == 500){ /*usbSerial.printf("time out\n\r");*/  return(ch_b);}
//      if(ii != 500){   usbSerial.printf("not5000\n\r");   } ///{ //jump bbb

        //1バイト分のデータの入力
        ch_y = usbSerial.getc();
        //テータの転記
        ch_b[ch_i]=ch_y;ch_i++;ch_b[ch_i]=0;ch_len++;
        //pc.putc(ch_y);
        usbSerial.printf( hex_b_c( ch_y ) ); 
        if(ch_i >= 9){ch_b[ch_i]=0;/*pc.printf("\n\r")*/;break;}     
    } //while
    return(ch_b);
} //ch_input

char *hex_table="01234567890ABCDEF";
char hex_b[2+1];
char *hex_b_c(int i_num)
{
    hex_b[0] = hex_table[i_num>>4];
    hex_b[1] = hex_table[i_num & 0xf];
    hex_b[2] = 0;
    return(hex_b);
}



///////////////////////////



int main() {
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    
//    Serial    pc(PA_2, PA_3);
//    USBSerial usbSerial;  // connection is blocked when USB is not plugged in
//      USBSerial usbSerial(0x1f00, 0x2012, 0x0001,  false);    // connection is not blocked when USB is not plugged in
//    USBSerial pc(0x1f00, 0x2012, 0x0001,  false);    // connection is not blocked when USB is not plugged in


    //pc.printf("\r\n103\r\n"); //103
    GPIOA->ODR = off1;
    wait_ms(1);

    CoreDebug->DEMCR |= CoreDebug_DEMCR_TRCENA_Msk;
    DWT->CTRL |= DWT_CTRL_CYCCNTENA_Msk;
    
    while(1) {
        //myled = !myled;
        //pc.printf("I am a serial port\r\n");            // 9600 bit/s
        //usbSerial.printf("I am a USB serial port\r\n"); // 12 Mbit/s (USB full-speed)

        //while(1){
        //    //usbSerial.printf("  -%d\r\n",usbSerial.readable());
        //    usbSerial.printf("  -%d\r\n",usbSerial.available());
        //    usbSerial.printf("  -%d\r\n",usbSerial.getc());
        //    wait_ms(1000);
        //}

        usbSerial.printf("ON RGB LED\r\n");
        
        ch_input();
        
        usbSerial.printf("\r\n"); //010

        for(int ii=0;ii<ch_len;ii++){
            l[ii] = ch_b[ii];
        }

        ws_led(ch_len);

        
//        l[0] = 31;
//        l[1] = 32;
//        l[2] = 33;
//
//        ws_led(3);

        
        //wait_ms(1000);
    }
}


// 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3 
void bit_off1(){
   //0.3us 800khz

        DWT->CYCCNT = 0;

        GPIOA->ODR = on1;

        while (DWT->CYCCNT < 17L){ 
         //a++;
        } ;

        GPIOA->ODR = off1;

        while (DWT->CYCCNT < 70L){ 
         //a++;
        } ;

}//bit_off1

// 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
void bit_on1(){
   //1us 800khz

        DWT->CYCCNT = 0;

        GPIOA->ODR = on1;

        while (DWT->CYCCNT < 47L){ 
         //a++;
        } ;

        GPIOA->ODR = off1;

        while (DWT->CYCCNT < 70L){ 
         //a++;
        } ;

}//bit_on1
