//電圧

#include "mbed.h"

//10の割り算 0から1028までは、正しい。主に0から999
#define DVI10(n) ((n*205)>>11)

//アナログ入力の設定
AnalogIn adc_vbat(A3); //PA_4
//AnalogIn adc_vbat(A0); //767

//Serial pc(USBTX, USBRX); // tx, rx
//Serial pc(SERIAL_TX, SERIAL_RX); //767
//Serial pc(PA_2, PA_3); //010
//Serial pc(PA_9, PA_10); //010
RawSerial pc(PA_2, PA_3); //010

char ch_hex_a_b[5];
char *ch_hex_a(int l_num)
{
    int a,b,c;

    b=DVI10(l_num);
    c=l_num-(b*10);
    a=DVI10(b);
    b=b-(a*10);

    ch_hex_a_b[0] = '0' + a;
    ch_hex_a_b[1] = '0' + b;
    ch_hex_a_b[2] = '0' + c;
    ch_hex_a_b[3] = 0;

    return(ch_hex_a_b);
} //ch_hex_a

//文字列の表示
int pc_printf(char *str1) {

    //文字の中身がゼロか
    while(*str1){
            
        //一文字出力
        pc.putc(*str1 ++);
                        
    } //while

    //戻り値
    return(0);
}//pc_printf

int main() {

    //無限ループ
    while(1) {

        //adcの読み込み 0から4096
        int s = (adc_vbat.read_u16()>>4);

//        pc.printf("\r\n -S=%d",s); //767

        //電圧に変換 ex 3.300 -> 3300 mVを出力
        s=(s*6600)>>13;

//        //s = 3300;
//        pc.printf("\t c=%d",s); //767

//小数点以上と小数点以下を分ける iiは1の桁 sは小数点以上の桁
int ii = s;
if     ( ii >= 3000 ) { ii = (ii - 3000); s = 3;}
else if( ii >= 2000 ) { ii = (ii - 2000); s = 2;}
else if( ii >= 1000 ) { ii = (ii - 1000); s = 1;}
else                  {                 ; s = 0;}

//        pc.printf("\t t=%d %d",s,ii); //767
//        pc.printf("\r\n"); //767 リターン


        //電圧の小数点以上の表示
        ch_hex_a( s*10 );
        ch_hex_a_b[0] = '+';
      //ch_hex_a_b[1] = '0' + s;
        ch_hex_a_b[2] = '.';      
        pc_printf(  ch_hex_a_b  );

        //電圧の小数点以下の表示
        pc_printf(  ch_hex_a(ii)  );

        //リターン
        pc_printf(  "\r\n"  );

        //1秒の待ち
        wait_ms(1000);

    } //while

} //main

//容量削減
void error(const char* format, ...){}

