#include "mbed.h"

//*******   ******   *****  *****  
//     *         *   *      * 
//    *         *    *****  *  ***
//  *       ****     *      *    *
//  *       *        *      *    *
//  *        *****   *****  *****

//10の割り算 0から1028までは、正しい。主に0から999
#define DVI10(n) ((n*205)>>11)

#define HIGH 1
DigitalIn in1(PA_1);

RawSerial pc(PA_2, PA_3); //010 tx, rx

//タイマーの設定
Timer t;


//文字列の表示 nana_seg
int ns_printf(char *str1) {

    //文字の中身がゼロか
    while(*str1){

        //一文字出力
    pc.putc(*str1 ++);

    } //while

    //戻り値
    return(0);
}//ns_printf



//in1のオン時間をusで測る　今のところ引数は、無効
int pulseIn(int pin1,int pu1,int timeout1)
{
    t.reset();

    //while(in1 != 0) {}

    loop_ins:
    //                      1234567890123456
    if (   (GPIOA->IDR) & 0b0000000000000010   ) { goto loop_ins;}

    //while(in1 == 0) {}

    loop_s1:
    //                            1234567890123456
    if (     (~(GPIOA->IDR))  & 0b0000000000000010    ) { goto loop_s1;}

    //led1 = 1;//debug

    int sd = t.read_us();


    //while(in1 != 0) {}

    loop_in1:
    //                      1234567890123456
    if (   (GPIOA->IDR) & 0b0000000000000010   ) { goto loop_in1;}

    //led1 = 0;//debug

    return(t.read_us()-sd);

}//pulseIn

//in1のオンオフ時間をusで測る　今のところ引数は、無効
int hzIn(int pin1,int pu1,int timeout1)
{
    t.reset();

    //while(in1 != 0) {}

    loop_ins:
    //                      1234567890123456
    if (   (GPIOA->IDR) & 0b0000000000000010   ) { goto loop_ins;}

    //while(in1 == 0) {}

    loop_s1:
    //                            1234567890123456
    if (     (~(GPIOA->IDR))  & 0b0000000000000010    ) { goto loop_s1;}

    //led1 = 1;//debug

    int sd = t.read_us();


    //while(in1 != 0) {}

    loop_in1:
    //                      1234567890123456
    if (   (GPIOA->IDR) & 0b0000000000000010   ) { goto loop_in1;}

    //while(in1 == 0) {}

    loop_e1:
    //                            1234567890123456
    if (     (~(GPIOA->IDR))  & 0b0000000000000010    ) { goto loop_e1;}


    //led1 = 0;//debug

    return(t.read_us()-sd);

}//hzIn

//メイン関数
int main() {

    char data_read[16]; //バッファー


    ns_printf("STAR\r\n");wait_ms(200); //debug

    t.start();

    //初期値の表示
    ns_printf("0000Hz\r\n");

    int pwmco2;
    int hz;
    
    int us;

    //無限ループ
    while(1){

        //PWMでデータ取得
        us=pulseIn(7 ,HIGH,2000000);
        //us=500;

        //周期でデータ取得
        pwmco2=hzIn(7 ,HIGH,2000000);
        //pwmco2=500;


        //周波数の計算
        //pwmco2=pwmco2*2;
        if(pwmco2==0){pwmco2=1;}
        hz = 1000000/pwmco2;

        //表示用の変数の初期化
        int s = hz;
        int n0,n10,n100,n1000,n10000;

        n10   = s / 10;            // 1234 -> 123
        n0    = s - (n10 *10);     // 1234 -  1230 -> 4
        n100  = n10 / 10;          // 123  -> 12
        n10   = n10 - (n100 *10);  // 123  -  120 -> 3
        n1000 = n100 / 10;         // 12   -> 1
        n100  = n100 - (n1000*10); // 12   -  10  -> 2

        //画面に表示
        data_read[0] = '0' + n1000;
        data_read[1] = '0' + n100;
        data_read[2] = '0' + n10;
        data_read[3] = '0' + n0;
        data_read[4] = 'H';
        data_read[5] = 'z';
        data_read[6] = ' '; //'\r';
        data_read[7] = 0;   //'\n';
        data_read[8] = 0;
        ns_printf(data_read);



        s=us;
        n10   = s / 10;            // 12345 -> 1234
        n0    = s - (n10 *10);     // 12345 -  12340 -> 5
        n100  = n10 / 10;          // 1234  -> 123
        n10   = n10 - (n100 *10);  // 1234  -  1230 -> 4
        n1000 = n100 / 10;         // 123   -> 12
        n100  = n100 - (n1000*10); // 123   -  120  -> 3
        n10000= n1000/ 10;         // 12    -> 1
        n1000 = n1000- (n10000*10);// 12    -  10   -> 2

        //画面に表示
        data_read[0] = '0' + n10000;
        data_read[1] = '0' + n1000;
        data_read[2] = '0' + n100;
        data_read[3] = '0' + n10;
        data_read[4] = '0' + n0;
        data_read[5] = 'u';
        data_read[6] = 'S';
        data_read[7] = '\r';
        data_read[8] = '\n';
        data_read[9] = 0;
        ns_printf(data_read);

        //約0.3秒待つ
        wait_ms(300);

    }//while

}//main

//容量削減
void error(const char* format, ...){}
