#include "mbed.h"

//Serial pc(USBTX, USBRX); // tx, rx
//Serial pc(SERIAL_TX, SERIAL_RX); //767
//Serial pc(PA_2, PA_3); //010
//Serial pc(PA_9, PA_10); //010

//data SG90
// 2400us 2.4ms
#define s_max  2400
// 500us 0.5ms
#define s_min  500 
#define s_r    (2400-500)
#define s_c    ((2400-500)/256)
#define SN(n6) (500+(((2400-500)/256)*n6))


//PWMのピンの設定
//PwmOut servo(A0); //       //767
PwmOut servo(A4); //PA_5   //010
 
int main() {

    //周期の設定    
    //servo.period(0.020);          // servo requires a 20ms period
    servo.period_ms (20);

    //無限ループ
    while (1) {
        
        //0から256までループ
        //for(float offset=0.0; offset<0.001; offset+=0.0001) {
        for(int offset=0; offset<256; offset++) {

            //pc.printf(" -S=%d\t%d\r\n", offset , SN(offset) ); //767
    
            //オン時間の設定
            //servo.pulsewidth(0.001 + offset); // servo position determined by a pulsewidth between 1-2ms  　　　
            servo.pulsewidth_us( SN(offset) );
        
            //250ミリ秒まつ
            //wait_ms(250);
            wait_ms(4);
        }//for
    }//while
}//main

//容量削減
void error(const char* format, ...){}
