#include "mbed.h"

//10の割り算 0から1028までは、正しい。主に0から999
#define DVI10(n) ((n*205)>>11)

//1000の割り算 だいたい正しい
#define DVI1000(n) ((n>>10)+(((n>>10)*32)>>10))

#define HIGH 1
DigitalIn in1(PA_1);

DigitalOut led1(PA_4); //debug

RawSerial pc(PA_2, PA_3); //010 tx, rx

//タイマーの設定
Timer t;

//in1のオン時間をusで測る　今のところ引数は、無効
int pulseIn(int pin1,int pu1,int timeout1)
{
    t.reset();

    //while(in1 != 0) {}

    loop_ins:
    //                      1234567890123456
    if (   (GPIOA->IDR) & 0b0000000000000010   ) { goto loop_ins;}

    //while(in1 == 0) {}

    loop_s1:
    //                            1234567890123456
    if (     (~(GPIOA->IDR))  & 0b0000000000000010    ) { goto loop_s1;}

    //led1 = 1;//debug

    int sd = t.read_us();


    //while(in1 != 0) {}

    loop_in1:
    //                      1234567890123456
    if (   (GPIOA->IDR) & 0b0000000000000010   ) { goto loop_in1;}

    //led1 = 0;//debug

    return(t.read_us()-sd);

}//pulseIn

int main() {

    t.start(); //pulseInで必要

    int pwmco2; //onの間隔 us

    //無限ループ
    while(1){

        //PWMでデータ取得
        pwmco2=pulseIn(7 ,HIGH,2000000);
        //pwmco2=82000; //debug
        printf("The time taken was %d seconds\r\n", pwmco2  );
        printf("The time taken was %d seconds\r\n", DVI1000(pwmco2)  );

        //0.1秒待つ
        wait_ms(100);

    }//while

}//main
