//
// 128*64
// 303 oled 8*16
//

#include "mbed.h"
#include "SSD1306.h"
#include "font_8x8.h"

DigitalOut myled(LED1);

#define ADDR     (0x3c<<1) //  address
//#define ADDR     (0x3d<<1) //  address

//I2C i2c(I2C_SDA, I2C_SCL);
I2C i2c(PB_7, PB_6); // STM32F103C8

// Host PC Communication channels
//Serial pc(USBTX, USBRX); // tx, rx
Serial pc(PA_9, PA_10); // tx, rx 103

// Instantiate OLED
SSD1306 oled(i2c, ADDR);

char ddff[8*4];

void char11(int row,int com,int cha)
{

    int char_index1;

    char_index1 = cha-0x20;

    int ii;

for (ii = 0;ii<(8*2);ii++) {ddff[ii]=0;} // オールクリア
for (ii =0;ii<8;ii++){
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 0) & 1)<<0; //1bit 1 
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 0) & 1)<<1; //1bit 2
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 1) & 1)<<2; //2bit 3
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 1) & 1)<<3; //2bit 4
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 2) & 1)<<4; //3bit 5
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 2) & 1)<<5; //3bit 6
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 3) & 1)<<6; //4bit 7
ddff[ii+ 0] = ddff[ii+ 0] | ((font_8x8[char_index1][ii] >> 3) & 1)<<7; //4bit 8
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 4) & 1)<<0; //5bit 1
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 4) & 1)<<1; //5bit 2
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 5) & 1)<<2; //6bit 3
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 5) & 1)<<3; //6bit 4
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 6) & 1)<<4; //7bit 5
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 6) & 1)<<5; //7bit 6
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 7) & 1)<<6; //8bit 7
ddff[ii+ 8] = ddff[ii+ 8] | ((font_8x8[char_index1][ii] >> 7) & 1)<<7; //8bit 8
}//for

oled.writeBitmap((uint8_t*) ddff,
              row, (row + 2 - 1),   //y
              com, (com + 8 - 1));  //x

} //end chr11    

int main() {
    int ii;
    pc.baud(9600);

    char ss1[]="Hello World !";
    ii=0;
    while(ss1[ii]!=0){
        //     y  x    文字
        char11(0,ii*8,ss1[ii]);ii++;
    }
    pc.printf("Printed something\r");    
}
