//i2c_slave_ir_length_010_1


#include "mbed.h"


//10の割り算 0から1028までは、正しい。主に0から999
#define DIV10(n) ((n*205)>>11)


#define HIGH 1
DigitalOut TRIG(PA_6);
DigitalIn  ECHO(PA_5);


//タイマーの設定
Timer t;

unsigned long times; //測定時間
int distance;        //長さ


//PA_5のオン時間をusで測る　今のところ引数は、無効
int pulseIn(int pin1,int pu1,int timeout1)
{

    t.reset();//タイマーの開始

    //timeout1 = 32000000;
    timeout1 = 100000;    //28ms
    //timeout1 = 1000;   //degbu

    //while(PA_5 == 0) {}

loop_s1:
    timeout1--;
    //                            5432109876543210
    if (     (~(GPIOA->IDR))  & 0b0000000000100000     ) {
        if ( timeout1 ) {
            goto loop_s1;
        }
    }


    int sd = t.read_us();//測定開始

    //timeout1 = 32000000;
    timeout1 = 100000;     //28ms
    //timeout1 = 1000;   //degbu

    //while(PA_5 != 0) {}

loop_in1:
    timeout1--;
    //                      5432109876543210
    if (   (GPIOA->IDR) & 0b0000000000100000   ) {
        if( timeout1 ) {
            goto loop_in1;
        }
    }

 
    return(t.read_us()-sd);//測定終了

}//pulseIn



/*
DigitalOut TX(PB_1);

//仮想シリアルへの一文字出力 1200bps
int pc_putc(char ch)
{
    TX=1;
    TX=0;//Start
    wait_us(832);

    for(int ii=0; ii<8; ii++) { //Data x 8
        TX=(ch>>ii)&1;
        wait_us(832);
    }; //for

    TX=1;//Stop
    wait_us(832);

    return(0);
} //pc_putc
*/


unsigned char b=200; //マスターに返す値

//I2Cの初期化
I2CSlave slave(PA_10, PA_9); //010

//メインルーチン
int main()
{

    //タイマーの開始
    t.start();

    //GPIOの初期化
    TRIG = 0;

    //TX=1; //ポートの初期化

    char buf[10];//I2Cバッファー

    //I2Cスレーブのアドレスの設定
    slave.address(0x10);

    //無限ループ
    while(1) {

        //I2Cの状態の読み出し(ポーリング)
        while(  slave.receive()  == I2CSlave::ReadAddressed   ) {};

        //b = 40; //debug
        buf[0] = b;

        //I2Cマスターに送信する
        slave.write(buf,1);

        /*

                //I2Cスレーブの送信データの表示 num debug
                int d = b; //buf[0];
                char data_read[3]; //バッファーの定義
                data_read[3] = 0;
                data_read[2] = '0' + (  d - (DIV10(d) * 10)  );  // '0'+(d%10)
                d = DIV10(d);
                data_read[1] = '0' + (  d - (DIV10(d) * 10)  );  // '0'+(d%10)
                data_read[0] = '0' +  DIV10(d);                  // '0'+(d/10)
                pc_putc(data_read[0]);
                pc_putc(data_read[1]);
                pc_putc(data_read[2]);
                pc_putc('\r');
                pc_putc('\n');
        */

        // 超音波を発生させる
        TRIG=1;
        wait_us(10);
        TRIG=0;

        // 超音波を受け取る
        times = pulseIn( 5, HIGH,2000000);

        //times = (unsigned long)7700/2; //debug

        //distance = (int)(times * 0.017);
        distance = (int)((times * ((unsigned long)(17))) / 100);


        if(distance <= 60   ) {
            distance = 60;
        }
        if(distance >= 800 ) {
            distance = 800;
        }

        if ( distance <= 199 ) {

            b = distance - 60;

        } else {

            b = (unsigned char)(   DIV10(distance)-20+140 );

        }


        //0.5秒の待ち
        //wait_ms(500);

    }//while

}//main


//容量削減
void error(const char* format, ...) {}



